// hotkeys.h
#pragma once
#include "dispimpl.hpp"
#include "commontlb.h"
#include "../../common/common_api.h"
#include "../Traps'n'Hooks/userhotkey.h"

class CIHotKey : public CDispImpl<CIHotKey,  com_type<IHotKey> >
{
public:
	CIHotKey(CHotKeyTrap::SKeyData* pKey) : m_pKey(pKey)
	{
		m_pKey->pComObject = this;
	}
	~CIHotKey()
	{
		if(m_pKey)
			m_pKey->pComObject = NULL;
	}
	
	STDMETHOD(get_KeyString)(BSTR *pVal);
	STDMETHOD(get_Macros)(BSTR *pVal);
	STDMETHOD(get_Addin)(BSTR *pVal);
	STDMETHOD(get_Key)(long* pVal);
	STDMETHOD(put_Key)(long newVal);
	STDMETHOD(SetCommand)(BSTR Addin, BSTR Macros);

	BEGIN_COM_MAP(CIHotKey)
		COM_INTERFACE_ENTRY(IHotKey)
	END_COM_MAP()

	static void Attach(CHotKeyTrap::SKeyData* pKey, IHotKey** ppVal)
	{
		if(pKey->pComObject)
		{
			*ppVal = pKey->pComObject;
			pKey->pComObject->CIHotKey::AddRef();
		}
		else
			*ppVal = new CIHotKey(pKey);
	}
protected:
	friend class CHotKeyTrap;
	CHotKeyTrap::SKeyData* m_pKey;
};

class CIHotKeys : public CDispImpl<CIHotKeys, com_type<IHotKeys> >
{
public:
	STDMETHOD(FindByKey)(long Key, IHotKey** ppKey);

	STDMETHOD(get_Item)(long Idx, IHotKey* *pVal);
	STDMETHOD(get_Count)(long *pVal);
	STDMETHOD(Add)(long Key, BSTR bAddin, BSTR Macros, IHotKey** pHotKey);
	STDMETHOD(Remove)(long Idx);
	STDMETHOD(ClearAll)();
	STDMETHOD(get_Cancel)(VARIANT_BOOL *pVal);
	STDMETHOD(put_Cancel)(VARIANT_BOOL newVal);

	BEGIN_COM_MAP(CIHotKeys)
		COM_INTERFACE_ENTRY(IHotKeys)
	END_COM_MAP()
};