// plugins.cpp
#include "StdAfx.h"
#include "plugins.h"
#include "../pluginmgr.h"
#include "plugin.h"
#include "enumvariant.hpp"

STDMETHODIMP CPlugins::get__NewEnum(IUnknown **pVal)
{
	if(!pVal)
		return E_POINTER;
	const CPluginMgr::PluginsArray& plugins = CPluginMgr::Get().GetPlugins();
	DWORD size = plugins.GetSize();
	CEnumVariant* pEnum = new CEnumVariant(size, 0);
	for(DWORD idx = 0; idx < size; idx++)
	{
		pEnum->m_pValues[idx].vt = VT_DISPATCH;
		pEnum->m_pValues[idx].pdispVal = new CPlugin(plugins[idx]);
	}
	*pVal = pEnum;
	return S_OK;
}

STDMETHODIMP CPlugins::get_item(VARIANT idx, IPlugin **pVal)
{
	if(!pVal)
		return E_POINTER;
	const CPluginMgr::SPluginInfo* pInfo;
	if(idx.vt == (VT_VARIANT | VT_BYREF))
		idx = *idx.pvarVal;

	if(VT_BSTR == (idx.vt & ~VT_BYREF))
	{
		_bstr_t bstrName(idx);
		pInfo = CPluginMgr::Get().GetPlugin(bstrName);
		if(!pInfo)
			return SetError(E_INVALIDARG, "    %s", (LPCSTR)bstrName);
	}
	else
	{
		if(idx.vt != VT_I4)
			VariantChangeType(&idx, &idx, 0, VT_I4);
		if(idx.vt == VT_I4)
		{
			const CPluginMgr::PluginsArray& plugins = CPluginMgr::Get().GetPlugins();
			DWORD dwIdx = idx.lVal;
			if(dwIdx >= plugins.GetSize())
				return SetError(E_INVALIDARG, "  (%i)     (0-%i)", idx.lVal, plugins.GetSize()-1);
			pInfo = plugins[dwIdx];
		}
		else
			return SetError(E_INVALIDARG, "  ");
	}
	*pVal = new CPlugin(pInfo);
	return S_OK;
}

STDMETHODIMP CPlugins::get_Count(long *pVal)
{
	if(!pVal)
		return E_POINTER;
	*pVal = CPluginMgr::Get().GetPlugins().GetSize();
	return S_OK;
}

STDMETHODIMP CPlugins::LoadPlugin(BSTR StrPath, IPlugin **pRetVal)
{
	if(!pRetVal)
		return E_POINTER;
	CString strPath(StrPath);

	const CPluginMgr::SPluginInfo* pInfo = CPluginMgr::Get().LoadPlugin(strPath);
	if(!pInfo)
		return SetError(E_FAIL, "    %s", strPath);
	*pRetVal = new CPlugin(pInfo);
	return S_OK;
}
