// panelview.cpp
#include "StdAfx.h"
#include "panelview.h"
#include "ov7panel.h"
#include "../../addin_work/addinmgrimpl.h"

IMPLEMENT_DYNCREATE(CPanelView, CView)

BEGIN_MESSAGE_MAP(CPanelView, CView)
	//{{AFX_MSG_MAP(CPanelView)
	ON_WM_SIZE()
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
	ON_NOTIFY(TCN_SELCHANGE,99,OnSwitchTab)
END_MESSAGE_MAP()

CPanelView::CPanelView()
{
	m_ActiveTab = -1;
	m_pTab = NULL;
	m_pIcons = NULL;
}

CPanelView::~CPanelView()
{
	delete m_pTab;
	delete m_pIcons;
}

void CPanelView::OnDraw(CDC* pDC)
{
}

void CPanelView::OnInitialUpdate()
{
	CView::OnInitialUpdate();
	ModifyStyleEx(WS_EX_CLIENTEDGE, 0);
	COpenV7Panel::SPanelInfo* pInfo = COpenV7Panel::GetInfo(m_pDocument);
	if(!pInfo)
		return;
	pInfo->pView = this;
	DWORD size = pInfo->tabs.GetSize();
	if(size > 1)
	{
		m_pTab=new CTabCtrl;
		m_pTab->Create(WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS|TCS_FOCUSNEVER|TCS_TABS|TCS_BOTTOM,CRect(0,0,0,0),this,99);
		m_pTab->SendMessage(WM_SETFONT,(WPARAM)GetStockObject(DEFAULT_GUI_FONT));
		m_pIcons = new CIconList;
		m_pTab->SendMessage(TCM_SETIMAGELIST, 0, (LPARAM)m_pIcons->GetList());
		ImageList_SetBkColor(m_pIcons->GetList(), GetSysColor(COLOR_BTNFACE));
	}
	for(int i=0, page = 0; i<size ; i++)
	{
		AddinStoreReal* pStore = static_cast<AddinStoreReal*>(addin_mgr::GetByUniqueName(pInfo->tabs[i]));
		if(pStore)
		{
			Addin* pAddin = pStore->GetAddin();
			TabSite* pSite = new TabSite;
			pSite->pWnd = (AddinWindow*)pAddin->Cast(aiWindow);
			if(pSite->pWnd && pSite->pWnd->CanCreateWnd())
			{
				pSite->pWnd->CreateWnd(this);
				if(pSite->pWnd->pAddinWnd)
				{
					pSite->idx = page;
					pSite->pOwner = this;
					pStore->pWndSite = pSite;
					m_tabs.Add(pSite);
					
					if(m_pTab)
					{
						pSite->pWnd->pAddinWnd->ModifyStyleEx(0, WS_EX_CLIENTEDGE);
						int iIcon = pAddin->GetImageIdx(*m_pIcons);
						m_pTab->InsertItem(page++, pAddin->DisplayName(), iIcon);
					}
					continue;
				}
			}
			delete pSite;
		}
	}
	if(m_pTab)
		m_pTab->SetWindowPos(&CWnd::wndBottom, 0, 0, 0, 0, SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE);
	m_ActiveTab = 0;
	RepositionControls();
}

void CPanelView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	RepositionControls();
}

BOOL CPanelView::PreTranslateMessage(MSG* pMsg) 
{
	return CView::PreTranslateMessage(pMsg);
}

void CPanelView::OnSetFocus(CWnd* pOldWnd) 
{
	CView::OnSetFocus(pOldWnd);
	if(m_ActiveTab >= 0)
		m_tabs[m_ActiveTab]->pWnd->pAddinWnd->SetFocus();
}

void CPanelView::RepositionControls()
{
	if(m_ActiveTab >= 0)
	{
		RECT rc;
		GetClientRect(&rc);
		if(m_pTab)
		{
			CRect adRect(rc);
			m_pTab->AdjustRect(FALSE, adRect);
			m_pTab->MoveWindow(0, adRect.bottom, rc.right, rc.bottom - adRect.bottom);
			rc.bottom = adRect.bottom;
		}
		CWnd* pWnd = m_tabs[m_ActiveTab]->pWnd->pAddinWnd;
		pWnd->ShowWindow(SW_HIDE);
		pWnd->MoveWindow(&rc);
		pWnd->ShowWindow(SW_SHOW);
	}
}

void CPanelView::DeleteTabSite(TabSite* pSite)
{
	for(int i = pSite->idx + 1, s = m_tabs.GetSize(); i<s ; i++)
		m_tabs[i]->idx--;
	m_tabs.RemoveAt(pSite->idx);
	
	if(m_pTab)
	{
		if(m_ActiveTab > pSite->idx)
			m_ActiveTab--;
		m_pTab->DeleteItem(pSite->idx);
		if(m_ActiveTab == m_pTab->GetItemCount())
			m_ActiveTab--;
	}
	else
		m_ActiveTab = -1;
	delete pSite;
	RepositionControls();
}

void CPanelView::UpdateTabSite(Addin* pAddin, TabSite* pSite)
{
	if(m_pTab)
	{
		TCITEM item;
		item.mask = TCIF_IMAGE | TCIF_TEXT;
		item.pszText  = (LPSTR)(LPCSTR)pAddin->DisplayName();
		item.iImage = pAddin->GetImageIdx(*m_pIcons);
		m_pTab->SetItem(pSite->idx, &item);
		pSite->pWnd->pAddinWnd->ModifyStyleEx(0, WS_EX_CLIENTEDGE);
		long res;
		OnSwitchTab(NULL, &res);
	}
	else
		RepositionControls();
}

void CPanelView::OnSwitchTab(NMHDR *phdr, LRESULT *pRes)
{
	*pRes=1;
	if(m_ActiveTab >= 0)
		m_tabs[m_ActiveTab]->pWnd->pAddinWnd->ShowWindow(SW_HIDE);
	m_ActiveTab = m_pTab->GetCurSel();
	
	if(m_ActiveTab >= 0)
	{
		CWnd* pWnd = m_tabs[m_ActiveTab]->pWnd->pAddinWnd;
		pWnd->SetWindowPos(&CWnd::wndTop, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
		pWnd->SetFocus();
	}
	RepositionControls();
}

void CPanelView::TabSite::DestroyWnd()
{
	pWnd->FreeWnd();
	pWnd = NULL;
}

BOOL CPanelView::TabSite::CreateWnd(Addin* pAddin)
{
	if(pAddin)
	{
		pWnd = (AddinWindow*)pAddin->Cast(aiWindow);
		if(pWnd && pWnd->CanCreateWnd())
		{
			pWnd->CreateWnd(pOwner);
			if(pWnd->pAddinWnd)
			{
				pOwner->UpdateTabSite(pAddin, this);
				return TRUE;
			}
		}
	}
	//   , ,  -   .
	pOwner->DeleteTabSite(this);
	return FALSE;
}

