// scriptimpl.h
#pragma once
#include "../addin_work/addinmgr.h"
#include "userform.h"

_COM_SMARTPTR_TYPEDEF(IDebugDocumentHelper, __uuidof(IDebugDocumentHelper));

class CScript : public IActiveScriptSite
	,public IActiveScriptSiteWindow
	,public IActiveScriptSiteDebug
{
public:
	LPCTSTR GetCurrentState();
	void CloseScript();
	CScript();
	~CScript();
	
	void FreeForm()
	{
		if(m_pForm)
		{
			if(POSITION pos = m_pForm->GetFirstViewPosition())
			{
				if(CView* pView = m_pForm->GetNextView(pos))
					pView->DestroyWindow();
			}
			delete m_pForm;
			m_pForm = NULL;
		}
	}
	static void Init();
	static void Done();
	BOOL Create(cstr strPath);
	void GetScriptObject(IDispatch** pDisp)
	{
		if(m_pEngine)
			m_pEngine->GetScriptDispatch(NULL, pDisp);
		else
			*pDisp = NULL;
	}
	cstr GetDisplayName()	{return m_DisplayName;}
	cstr GetUniqueName()	{return m_UniqueName;}
	cstr GetPath()			{return m_Path;}
	CUserFormDoc* GetForm()	{return m_pForm;}
protected:
	int ReportError(IActiveScriptError *pse, BOOL bDebug = TRUE);
	BOOL ProcessSource(cstr strSource);
	
	BOOL AddAddin(cstr strName, LPCSTR cstrAlias, BOOL bGlobal);
	void InitEngine();
	void CloseEngine();
	
	// IActiveScriptSite
	STDMETHOD(GetLCID)(LCID *plcid);
	STDMETHOD(GetDocVersionString)(BSTR *pszVersion);
	STDMETHOD(OnScriptTerminate)(const VARIANT *pvarResult, const EXCEPINFO *pexcepinfo);
	STDMETHOD(GetItemInfo)(LPCOLESTR pstrName, DWORD dwReturnMask,IUnknown **ppiunkItem,ITypeInfo **ppti);
	STDMETHOD(OnStateChange)(SCRIPTSTATE ssScriptState);
	STDMETHOD(OnScriptError)(IActiveScriptError *pscripterror);
	STDMETHOD(OnEnterScript)(void);
	STDMETHOD(OnLeaveScript)(void);
	
	// IActiveScriptSiteWindow
	STDMETHOD(GetWindow)(HWND* phWnd);
	STDMETHOD(EnableModeless)(BOOL);

	// IActiveScriptSiteDebug
	STDMETHOD(GetApplication)(IDebugApplication **ppda);
	STDMETHOD(GetRootApplicationNode)(IDebugApplicationNode **ppdanRoot);
	STDMETHOD(GetDocumentContextFromPosition)(
		DWORD dwSourceContext,
		ULONG uCharacterOffset,
		ULONG uNumChars,
		IDebugDocumentContext **ppsc);
	STDMETHOD(OnScriptErrorDebug)(IActiveScriptErrorDebug *pErrorDebug,
		BOOL *pfEnterDebugger,
		BOOL *pfCallOnScriptErrorWhenContinuing);
	
	// IUnknown
	HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid,void **ppvObject);
	ULONG STDMETHODCALLTYPE AddRef();
	ULONG STDMETHODCALLTYPE Release();
	
	DWORD m_dwRef;
	DWORD m_EnterCount;
	int	  m_DelayUnload;
	CNoCaseMap<IDispatch*> m_Items;
	IDebugDocumentHelperPtr m_pDebugDocumentHelper;
	IActiveScriptPtr m_pEngine;
	CString m_DisplayName, m_UniqueName, m_Path, m_EngineName;
	CUserFormDoc* m_pForm;

	static void DelayUnload();
		

	friend class CScriptAddin;

	static CNoCaseMap<CString> m_mapEngineNames;
	static IProcessDebugManager* m_pProcDebugManager;
	static IDebugApplication* m_pDebugApplication;
	static DWORD m_dwDebugCookie;
	static CTypedPtrArray<CPtrArray, CScript*> m_unload;
};
