// BaseTree.cpp : implementation file
//

#include "stdafx.h"
#include "starter.h"
#include "BaseTree.h"
#include "baselist.h"
#include "starterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBaseTree

CBaseTree::CBaseTree()
{
}

CBaseTree::~CBaseTree()
{
}


BEGIN_MESSAGE_MAP(CBaseTree, CTreeCtrl)
	//{{AFX_MSG_MAP(CBaseTree)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBaseTree message handlers

void CBaseTree::PreSubclassWindow() 
{
	SendMessage(TVM_SETIMAGELIST, TVSIL_NORMAL, (LPARAM)m_IconList.hList);
	CTreeCtrl::PreSubclassWindow();
}

void CBaseTree::FillGroup(CDataItem* pGroup, HTREEITEM parent)
{
	for(CDataItem::iterator it = pGroup->Child(); it ;++it)
	{
		int iIconIdx = it->GetIconIdx(m_IconList);
		HTREEITEM item = InsertItem(it->GetTitle(), iIconIdx, iIconIdx, parent);
		SetItemData(item, (DWORD)(CDataItem*)it);
		FillGroup(it, item);
	}
}

void CBaseTree::FillTree()
{
	FillGroup(CBaseList::GetBaseList().GetBases(), TVI_ROOT);
}

BOOL CBaseTree::IsBaseSelected()
{
	HTREEITEM item=GetNextItem(TVI_ROOT, TVGN_CARET);
	if(item)
	{
		int i1, i2;
		GetItemImage(item, i1, i2);
		return i1==1;
	}
	return FALSE;	
}

CString CBaseTree::GetCurrentPath()
{
	HTREEITEM item=GetNextItem(TVI_ROOT, TVGN_CARET);
	if(item)
	{
		int i1, i2;
		GetItemImage(item, i1, i2);
		if(i1==1)
		{
			//base* pBase=(base*)GetItemData(item);
			//return pBase->path;
		}
	}
	return CString();
}

void CBaseTree::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	*pResult = 0;
	CDataItem* pData = reinterpret_cast<CDataItem*>(pNMTreeView->itemNew.lParam);
	if(pData)
	{
		COCDlg* pDlg = static_cast<COCDlg*>(GetParent());
		CString commetn;
		pData->GetComment(commetn);
		pDlg->m_status.SetWindowText(commetn);
	}
}
