//data_gui.h
#pragma once

/*
    GUI     .
  GUI   ,     GUI.
 ,   GUI,      .
     ( )
  data_gui_impl.hpp
*/
template<typename GUI>
class CDataGuiItem
{
public:
	typedef CDataGuiItem<GUI> DG_BaseType;
	typedef GUI gui_base;
	typedef typename gui_base::gui_item gui_item;
protected:
	CString m_title;
	DG_BaseType *m_parent, *m_child, *m_next;

	CDataGuiItem(DG_BaseType* p, cstr t) : m_title(t)
	{
		m_child = NULL;
		m_parent = p;
		if(m_parent)
		{
			m_next = m_parent->m_child;
			m_parent->m_child = this;
		}
		else
			m_next = NULL;
	}
	void DeleteFromParent()
	{
		DG_BaseType** ppNext = &m_parent->m_child;
		while(*ppNext!=this)
			ppNext = &(*ppNext)->m_next;
		*ppNext = m_next;
		delete this;
	}
public:
	gui_item m_guiItem;
	
	virtual ~CDataGuiItem()
	{
		for(iter it(m_child);it;)
			delete (DG_BaseType*)it++;
	}
	class iter
	{
		DG_BaseType *ptr;
		friend class DG_BaseType;
	public:
		iter(DG_BaseType* p) :			ptr(p){}
		iter(const DG_BaseType* p) :	ptr(const_cast<DG_BaseType*>(p)){}
		iter(const iter& p) :			ptr(p.ptr){}
		operator DG_BaseType* ()
			{return ptr;}
		operator const DG_BaseType* ()const
			{return ptr;}
		operator BOOL () const
			{return ptr!=NULL;}
		BOOL operator ! () const
			{return ptr==NULL;}
		DG_BaseType* operator -> ()
			{return ptr;}
		const DG_BaseType* operator -> () const
			{return ptr;}
		DG_BaseType& operator * ()
			{return *ptr;}
		const DG_BaseType& operator * ()const
			{return *ptr;}

		iter& operator ++ (){ptr = ptr->m_next;return *this;}
		iter  operator ++ (int){iter t(ptr);ptr = ptr->m_next;return t;}
	};
	friend class iter;
	//   
	iter Child()	{return iter(m_child);}
	iter Next()		{return iter(m_next);}
	iter Parent()	{return iter(m_parent);}

	//    GUI
	cstr GetTitle() const {return m_title;}
	virtual void GetToolTip(CString& text)=0;
	//    
	virtual BOOL IsItBase() = 0;
	//    GUI
	virtual void Insert(gui_base& gui, gui_item& parent)=0;
	//  -    GUI
	virtual void OnSelect(gui_base& gui)=0;
	//  
	virtual void DeleteLink(gui_base& gui, BOOL bForce)=0;
	//  
	virtual void OpenObject(gui_base& gui)=0;
	//   
	virtual void CreateLinkFolder(gui_base& gui)=0;
	//     
	virtual void CreateLink2LinkFolder(gui_base& gui)=0;
	//       
	virtual void CreateLink2BasesFolder(gui_base& gui)=0;
	//      
	virtual void CreateLink2BaseDir(gui_base& gui)=0;
	//    
	virtual void CreateBaseDir(gui_base& gui)=0;
	//  
	virtual DWORD RunBase(WORD runMode)=0;
	//   
	virtual void OpenProps(gui_base& gui)=0;
	//   
	virtual void OpenLinkProps(gui_base& gui)=0;
	virtual void ToString(CString& str)=0;
};
