// baselist.h
#pragma once
#include "base_tree_nodes/data_gui.h"

template<typename GUI>
class CBaseList
{
public:
	typedef CDataGuiItem<GUI> data_item;
	CBaseList(GUI& gui)
		{Load(gui);}

	~CBaseList()
		{delete m_pBases;}
	
	data_item* GetBases()
		{return m_pBases;}

	cstr GetBaseListLocation(){return m_strBaseListLocation;}

	void ReLoad(GUI& gui)
	{
		delete m_pBases;
		Load(gui);
	}
	void CreateLinkFolder(GUI& gui, data_item* pParent, cstr pParentPath);
	void CreateLink2LinkFolder(GUI& gui, data_item* pParent, cstr pParentPath);
	void CreateLink2BasesFolder(GUI& gui, data_item* pParent, cstr pParentPath);
	void CreateLink2BaseDir(GUI& gui, data_item* pParent, cstr pParentPath);
	void CreateBaseDir(GUI& gui, data_item* pParent, cstr pParentPath);

protected:
	void Load(GUI& gui);
	data_item* m_pBases;
	CString m_strBaseListLocation;
};
