// CoolButton.cpp : implementation file
//

#include "stdafx.h"
#include "../starter.h"
#include "CoolButton.h"
#include "EnBitmap.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoolButton


CCoolButton::CCoolButton():
	m_nIdResLo(0), m_nIdResHi(0), m_hList(NULL), m_mask(0)
{
	ReleaseBitmaps();
}

CCoolButton::~CCoolButton()
{
	ReleaseBitmaps();
}

void CCoolButton::ReleaseBitmaps()
{
	if(m_hList)
	{
		ImageList_Destroy(m_hList);
		m_hList=NULL;
	}
	memset(m_hBmps, -1, sizeof(m_hBmps));
}

BEGIN_MESSAGE_MAP(CCoolButton, CButton)
	//{{AFX_MSG_MAP(CCoolButton)
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CCoolButton::SetResID(UINT nLoColor, UINT nHiColor, COLORREF clrMask/*=RGB(255, 0, 255)*/)
{
	ReleaseBitmaps();

	m_nIdResLo=nLoColor;
	m_nIdResHi=nHiColor;
	m_mask=clrMask;

	Invalidate();
}

static struct _theme
{
	void Init()
	{
		hThemeDll=GetModuleHandle("UxTheme.dll");
		if(hThemeDll)
			bNeedFree=FALSE;
		else
		{
			hThemeDll=LoadLibrary("UxTheme.dll");
			bNeedFree=TRUE;
		}
		IsThemeActive=(PTH_BV)GetProcAddress(hThemeDll, "IsThemeActive");
		DrawThemeBackground=(PDrawThemeBackground)GetProcAddress(hThemeDll, "DrawThemeBackground");
		OpenThemeData=(POpenThemeData)GetProcAddress(hThemeDll, "OpenThemeData");
		CloseThemeData=(PCloseThemeData)GetProcAddress(hThemeDll, "CloseThemeData");
	}
	void Done()
	{
		if(bNeedFree)
			FreeLibrary(hThemeDll);
	}

	typedef BOOL(__stdcall *PTH_BV)();
	PTH_BV IsThemeActive;
	
	typedef HANDLE HTHEME;
	typedef HRESULT (__stdcall *PDrawThemeBackground)(HTHEME, HDC, int, int, const RECT *, const RECT *);
	PDrawThemeBackground DrawThemeBackground;

	typedef HTHEME (__stdcall *POpenThemeData)(HWND, LPCWSTR);
	POpenThemeData OpenThemeData;

	typedef HRESULT (__stdcall *PCloseThemeData)(HTHEME);
	PCloseThemeData CloseThemeData;

	BOOL bNeedFree;
	HINSTANCE hThemeDll;
}theme;

int CCoolButton::GetBitmapPos(CCoolButton::bmpIdxs idx)
{
	if(m_hBmps[idx]<0)
	{
		HBITMAP hAddedBmp=NULL;
		CEnBitmap enBmp;
		switch(idx)
		{
		case loEnabled:
			enBmp.LoadBitmap(m_nIdResLo);
			hAddedBmp=(HBITMAP)enBmp.Detach();
			break;
		case loDisabled:
			enBmp.LoadBitmap(m_nIdResLo);
			enBmp.MakeDisabled(m_mask);
			hAddedBmp=(HBITMAP)enBmp.Detach();
			break;
		case hiEnabled:
			enBmp.LoadBitmap(m_nIdResHi);
			enBmp.MakeNotActive(m_mask);
			hAddedBmp=(HBITMAP)enBmp.Detach();
			break;
		case hiDisabled:
			enBmp.LoadBitmap(m_nIdResHi);
			enBmp.MakeDisabled(m_mask);
			hAddedBmp=(HBITMAP)enBmp.Detach();
			break;
		case hiHot:
			enBmp.LoadBitmap(m_nIdResHi);
			hAddedBmp=(HBITMAP)enBmp.Detach();
			break;
		}
		if(!m_hList)
		{
			BITMAP bmp;
			::GetObject(hAddedBmp, sizeof(bmp), &bmp);
			m_imgWidth=bmp.bmWidth;
			m_imgHeight=bmp.bmHeight;
			m_hList=ImageList_Create(m_imgWidth, m_imgHeight, ILC_MASK|ILC_COLOR32, 0, 1);
		}
		m_hBmps[idx]=ImageList_AddMasked(m_hList, hAddedBmp, m_mask);
		DeleteObject(hAddedBmp);
	}
	return m_hBmps[idx];
}

void CCoolButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	HDC hDC=lpDrawItemStruct->hDC;

	SetBkColor(hDC, GetSysColor(COLOR_BTNFACE));
	ExtTextOut(hDC, 0, 0, ETO_OPAQUE, &lpDrawItemStruct->rcItem, NULL, 0, NULL);

	BOOL bIsDisabled=(lpDrawItemStruct->itemState & ODS_DISABLED)!=0;
	BOOL bIsHot=FALSE;
	BOOL bIsPushed=(GetState() & BST_PUSHED)!=0;

	CPoint pt;
	GetCursorPos(&pt);
	ScreenToClient(&pt);

	if(PtInRect(&lpDrawItemStruct->rcItem, pt) && !bIsDisabled)
	{
		bIsHot=TRUE;
		if(theme.hThemeDll && theme.IsThemeActive())
		{
			_theme::HTHEME hTheme=theme.OpenThemeData(m_hWnd, L"BUTTON");
			theme.DrawThemeBackground(hTheme, hDC, 1, bIsPushed ? 3 : 2, &lpDrawItemStruct->rcItem, NULL);
			theme.CloseThemeData(hTheme);
		}
		else
		{
			CDC dc;
			dc.Attach(hDC);
			COLORREF clr1=GetSysColor(COLOR_3DHILIGHT),
				clr2=GetSysColor(COLOR_3DSHADOW), tmp;
			if(bIsPushed)
				tmp=clr1, clr1=clr2, clr2=tmp;
			dc.Draw3dRect(&lpDrawItemStruct->rcItem, clr1, clr2);
			dc.Detach();
		}
	}
	bmpIdxs idx;
	if(GetDeviceCaps(hDC, BITSPIXEL)>8)
	{
		if(bIsDisabled)
			idx=hiDisabled;
		else if(bIsHot)
			idx=hiHot;
		else
			idx=hiEnabled;
	}
	else
	{
		if(bIsDisabled)
			idx=loDisabled;
		else
			idx=loEnabled;
	}
	int nPos=GetBitmapPos(idx);
	int imgTop=(lpDrawItemStruct->rcItem.bottom-m_imgHeight)/2,
		imgLeft=4;
	CRect rc=lpDrawItemStruct->rcItem;
	rc.left=imgLeft+m_imgWidth+2;

	if(bIsPushed)
		imgTop++, imgLeft++, rc.top+=2, rc.left++;
	ImageList_Draw(m_hList, nPos, hDC, imgLeft, imgTop, ILD_NORMAL);

	HFONT hOldFont=NULL;
	if(LOWORD(GetParent()->SendMessage(DM_GETDEFID))==GetDlgCtrlID())
	{
		HFONT hFont=(HFONT)GetCurrentObject(hDC, OBJ_FONT);
		LOGFONT lf;
		GetObject(hFont, sizeof(lf), &lf);
		lf.lfWeight=700;
		hFont=CreateFontIndirect(&lf);

		hOldFont=(HFONT)SelectObject(hDC, hFont);
	}
	
	CString caption;
	GetWindowText(caption);
	SetBkMode(hDC, TRANSPARENT);
	
	SIZE szText;
	GetTextExtentPoint(hDC, caption, caption.GetLength(), &szText);

	DrawState(hDC, NULL, NULL, (LPARAM)(LPCTSTR)caption, 0, rc.left,
		(lpDrawItemStruct->rcItem.bottom-szText.cy)/2 + (bIsPushed ? 1 : 0), 0, 0,
		DST_TEXT | (lpDrawItemStruct->itemState & ODS_DISABLED ? DSS_DISABLED : DSS_NORMAL));

	if(lpDrawItemStruct->itemState & ODS_FOCUS)
	{
		rc=lpDrawItemStruct->rcItem;
		rc.InflateRect(-3, -3);
		DrawFocusRect(hDC, rc);
	}
	if(hOldFont)
		DeleteObject(SelectObject(hDC, hOldFont));
}

void CCoolButton::Init()
{
	if(dwOSVersion>5000)
		theme.Init();
}

void CCoolButton::OnMouseMove(UINT nFlags, CPoint point) 
{
	CButton::OnMouseMove(nFlags, point);
	if(::GetCapture()!=m_hWnd)
	{
		SetCapture();
		Invalidate();
	}
	else
	{
		CRect rc;
		GetClientRect(rc);
		if(!PtInRect(rc, point))
		{
			ReleaseCapture();
			Invalidate();
		}
	}
}

INIT_FUNC(CCoolButton::Init);