// MyToolBar.cpp : implementation file
//

#include "stdafx.h"
#include "../resource.h"
#include "MyToolBar.h"
#include "EnBitmap.h"

//#include "NoFlickPaint.h"

/////////////////////////////////////////////////////////////////////////////
// CMyToolBar

CMyToolBar::CMyToolBar()
{
	m_ttBuffer = new WCHAR[0x1000];
}

CMyToolBar::~CMyToolBar()
{
	delete [] m_ttBuffer;
	for(POSITION pos = m_tooltips.GetStartPosition();pos;)
	{
		void *key, *ptr;
		m_tooltips.GetNextAssoc(pos, key, ptr);
		delete [] reinterpret_cast<char*>(ptr);
	}
}


BEGIN_MESSAGE_MAP(CMyToolBar, CToolBarCtrl)
	//{{AFX_MSG_MAP(CMyToolBar)
	ON_WM_DESTROY()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_IDLEUPDATECMDUI, OnIdleUpdateCmdUI)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyToolBar message handlers
struct CToolBarData
{
	WORD wVersion;
	WORD wWidth;
	WORD wHeight;
	WORD wItemCount;
	//WORD aItems[wItemCount]

	WORD* items()
		{ return (WORD*)(this+1); }
};

void CMyToolBar::Create(CWnd *pParent, UINT nResID, UINT nHiResID, CRect &rc, UINT id, DWORD dwStyles)
{
	//     
	CToolBarCtrl::CreateEx(0, TOOLBARCLASSNAME, NULL,
		dwStyles | WS_TABSTOP | TBSTYLE_TOOLTIPS | TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_WRAPABLE |
		WS_CHILD |WS_VISIBLE  | CCS_NODIVIDER    | CCS_NORESIZE,
		rc,pParent,id);
	DefWindowProc(TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0);
	
	//  
	HRSRC hRsrc = ::FindResource(hMyInst, (LPCTSTR) nResID, RT_TOOLBAR);
	if (hRsrc == NULL)
		return;
	HGLOBAL hGlobal = LoadResource(hMyInst, hRsrc);
	if (hGlobal == NULL)
		return;
	CToolBarData* pData = (CToolBarData*)LockResource(hGlobal);
	if(pData==NULL)
	{
		FreeResource(hGlobal);
		return;
	}

	DefWindowProc(TB_SETBITMAPSIZE, 0, MAKELONG(pData->wWidth, pData->wHeight));
	DefWindowProc(TB_SETBUTTONSIZE, 0, MAKELONG(pData->wWidth+10, pData->wHeight+10));

	//      
	TBBUTTON *pButtons=new TBBUTTON[pData->wItemCount], *pInfo=pButtons;
	int nPictIdx=0;
	WORD* pBtnID=pData->items();

	//            .
	for(int i=0;i<pData->wItemCount;i++)
	{
		memset(pInfo, 0, sizeof(*pInfo));
		pInfo->iString=-1;
		pInfo->idCommand=*pBtnID;
		if(*pBtnID)
		{
			pInfo->fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
			pInfo->fsState = TBSTATE_ENABLED;
			pInfo->iBitmap = nPictIdx++;	//  
			//    
			char strRes[0x101];
			int nLen=LoadString(hMyInst, *pBtnID, strRes, 0x100);
			LPTSTR ptr=strRes;
			while(*ptr && *ptr!='\n')ptr++;
			int ttLen=ptr-strRes;
			char *tooltip=new char[ttLen+1];
			memcpy(tooltip,strRes,ttLen);
			tooltip[ttLen]=0;
			m_tooltips[(void*)pInfo->idCommand] = tooltip;
			if(*ptr)
			{
				LPCTSTR pText=++ptr;
				while(*ptr)ptr++;
				if(ptr>pText)
				{
					*++ptr=0;
					pInfo->iString=DefWindowProc(TB_ADDSTRING,NULL,(LPARAM)pText);
				}				
			}
		}
		else
			pInfo->fsStyle=TBSTYLE_SEP;
		pBtnID++;
		pInfo++;
	}
	
	UnlockResource(hGlobal);
	FreeResource(hGlobal);

	BOOL bIsCool=FALSE;
	if(nHiResID && dwShellVersion>=4070)
	{
		HDC hDC=::GetDC(NULL);
		if(GetDeviceCaps(hDC, BITSPIXEL)>8)
			bIsCool=TRUE;
		::ReleaseDC(NULL, hDC);
	}
	if(bIsCool)
	{
		//  hotimages
		HBITMAP hBmp=::LoadBitmap(hMyInst, (LPCTSTR)nHiResID);
		HIMAGELIST hImgList=ImageList_Create(pData->wWidth, pData->wHeight, ILC_COLOR32|ILC_MASK,nPictIdx,1);
		ImageList_AddMasked(hImgList, hBmp, RGB(255,0,255));
		DefWindowProc(TB_SETHOTIMAGELIST, 0, (LPARAM)hImgList);
		DeleteObject(hBmp);

		//  disabled images
		CEnBitmap enBmp;
		hBmp=::LoadBitmap(hMyInst, (LPCTSTR)nHiResID);
		enBmp.Attach(hBmp);
		enBmp.MakeDisabled(RGB(255,0,255));
		hImgList=ImageList_Create(pData->wWidth, pData->wHeight, ILC_COLOR32|ILC_MASK,nPictIdx,1);
		ImageList_AddMasked(hImgList, (HBITMAP)enBmp.GetSafeHandle(), RGB(255,0,255));
		DefWindowProc(TB_SETDISABLEDIMAGELIST, 0, (LPARAM)hImgList);
		
		//   images
		enBmp.DeleteObject();
		hBmp=::LoadBitmap(hMyInst, (LPCTSTR)nHiResID);
		enBmp.Attach(hBmp);
		enBmp.MakeNotActive(RGB(255,0,255));
		hImgList=ImageList_Create(pData->wWidth, pData->wHeight, ILC_COLOR32|ILC_MASK,nPictIdx,1);
		ImageList_AddMasked(hImgList, (HBITMAP)enBmp.GetSafeHandle(), RGB(255,0,255));
		DefWindowProc(TB_SETIMAGELIST, 0, (LPARAM)hImgList);
	}
	else
	{
		TBADDBITMAP addBitmap;
		addBitmap.hInst = hMyInst;
		addBitmap.nID = nResID;
		DefWindowProc(TB_ADDBITMAP, nPictIdx, (LPARAM)&addBitmap);
	}
	//    
	DefWindowProc(TB_ADDBUTTONS,pData->wItemCount,(LPARAM)pButtons);
	//DefWindowProc(TB_SETROWS, MAKEWPARAM(pData->wItemCount,TRUE),0);
	delete [] pButtons;
}

void CMyToolBar::OnDestroy() 
{
	CToolBarCtrl::OnDestroy();
	HIMAGELIST hImgList=(HIMAGELIST)DefWindowProc(TB_GETIMAGELIST,0,0);
	if(hImgList)
		ImageList_Destroy(hImgList);
	hImgList=(HIMAGELIST)DefWindowProc(TB_GETDISABLEDIMAGELIST,0,0);
	if(hImgList)
		ImageList_Destroy(hImgList);
	hImgList=(HIMAGELIST)DefWindowProc(TB_GETHOTIMAGELIST,0,0);
	if(hImgList)
		ImageList_Destroy(hImgList);
}

BOOL CMyToolBar::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	NMHDR* pHdr=(NMHDR*)lParam;
	if(pHdr->code==(UINT)TTN_NEEDTEXTA || pHdr->code==(UINT)TTN_NEEDTEXTW)
	{
		char* text;
		if(m_tooltips.Lookup((void*)pHdr->idFrom, (void*&)text))
		{
			if(pHdr->code==TTN_NEEDTEXTA)
				reinterpret_cast<TOOLTIPTEXTA*>(lParam)->lpszText = text;
			else
			{
				_mbstowcsz(m_ttBuffer, text, 0x1000);
				reinterpret_cast<TOOLTIPTEXTW*>(lParam)->lpszText = m_ttBuffer;
			}
		}
		return TRUE;
	}
	return CToolBarCtrl::OnNotify(wParam, lParam, pResult);
}

class CToolCmdUI : public CCmdUI        // class private to this file !
{
public: // re-implementations only
	virtual void Enable(BOOL bOn);
	virtual void SetCheck(int nCheck);
	virtual void SetText(LPCTSTR lpszText);
};

void CToolCmdUI::Enable(BOOL bOn)
{
	m_bEnableChanged = TRUE;
	CMyToolBar* pToolBar = (CMyToolBar*)m_pOther;
	DWORD fsState =pToolBar->DefWindowProc(TB_GETSTATE, m_nID, 0);
	if(bOn)
		fsState|=TBSTATE_ENABLED;
	else
		fsState &=~(TBSTATE_ENABLED|TBSTATE_PRESSED);
	pToolBar->DefWindowProc(TB_SETSTATE, m_nID, fsState);
}

void CToolCmdUI::SetCheck(int nCheck)
{
	CMyToolBar* pToolBar = (CMyToolBar*)m_pOther;
	if(nCheck==1 || nCheck==0)
		pToolBar->DefWindowProc(TB_PRESSBUTTON, m_nID, nCheck);
	else
		pToolBar->DefWindowProc(TB_INDETERMINATE, m_nID, TRUE);
}

void CToolCmdUI::SetText(LPCTSTR)
{
}


LRESULT CMyToolBar::OnIdleUpdateCmdUI(WPARAM wParam, LPARAM)
{
	if(IsWindowVisible())
	{
		CFrameWnd* pTarget=(CFrameWnd*)GetParent();//Frame();
		BOOL bDisableIfNoHndler=(BOOL)wParam;

		CToolCmdUI state;
		state.m_pOther = this;

		state.m_nIndexMax = (UINT)DefWindowProc(TB_BUTTONCOUNT, 0, 0);
		for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax; state.m_nIndex++)
		{
			// get buttons state
			TBBUTTON button;
			DefWindowProc(TB_GETBUTTON, state.m_nIndex, (LPARAM)&button);
			state.m_nID = button.idCommand;

			// ignore separators
			if (!(button.fsStyle & TBSTYLE_SEP))
			{
				// allow reflections
				if (CWnd::OnCmdMsg(0,
					MAKELONG((int)CN_UPDATE_COMMAND_UI, WM_COMMAND+WM_REFLECT_BASE),
					&state, NULL))
					continue;

				// allow the toolbar itself to have update handlers
				if (CWnd::OnCmdMsg(state.m_nID, CN_UPDATE_COMMAND_UI, &state, NULL))
					continue;

				// allow the owner to process the update
				state.DoUpdate(pTarget, bDisableIfNoHndler);
			}
		}
		UpdateDialogControls(pTarget, TRUE);
	}
	return 0;
}

int CMyToolBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CToolBarCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;
	return 0;
}

void CMyToolBar::MakeSomeWidth()
{
	/*
	int nBtns=GetButtonCount(), max=0;
	
	TBBUTTON btn;
	TBBUTTONINFO info;
	info.cbSize=sizeof(info);
	info.dwMask=TBIF_SIZE;
	
	for(int i=0;i<nBtns;i++)
	{
		GetButton(i, &btn);
		GetButtonInfo(btn.idCommand, &info);
		if(max<info.cx)
			max=info.cx;
	}
	info.cx=max;
	for(i=0;i<nBtns;i++)
	{
		GetButton(i, &btn);
		SetButtonInfo(btn.idCommand, &info);
	}
	*/
	//SetButtonWidth(100, 100);
}

void CMyToolBar::GetToolTip(UINT cmdID, CString &tt)
{
	void* text;
	if(m_tooltips.Lookup((void*)cmdID, text))
		tt = reinterpret_cast<LPCSTR>(text);
	else
		tt.Empty();
}

void CMyToolBar::SetToolTip(UINT cmdID, cstr tt)
{
	char* text;
	if(m_tooltips.Lookup((void*)cmdID, (void*&)text))
		delete [] text;
	DWORD dwLen = tt.GetLength()+1;
	text = new char[dwLen];
	memcpy(text, (LPCSTR)tt, dwLen);
	m_tooltips[(void*)cmdID] = text;
	HWND hToolTip = (HWND)DefWindowProc(TB_GETTOOLTIPS, 0, 0);
	if(::IsWindowVisible(hToolTip))
	{
		::SendMessage(hToolTip, TTM_UPDATE, 0, 0);
	}
}
