// starter.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "starter.h"
#include "starterDlg.h"
#include "settings.h"
#include "baselist.h"
#include "../injector/injector.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void GetOSShellVersion()
{
	HINSTANCE hShell32 = GetModuleHandle("shell32.dll");
	if(hShell32)
	{
		DLLGETVERSIONPROC pDllGetVersion;
		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress(hShell32, "DllGetVersion");
		if(pDllGetVersion)
		{
			DLLVERSIONINFO    dvi;
			ZeroMemory(&dvi, sizeof(dvi));
			dvi.cbSize = sizeof(dvi);
			pDllGetVersion(&dvi);
			dwShellVersion = dvi.dwMajorVersion*1000+dvi.dwMinorVersion;
		}
	}
	OSVERSIONINFO info;
	info.dwOSVersionInfoSize=sizeof(info);
	GetVersionEx(&info);
	if(info.dwPlatformId == VER_PLATFORM_WIN32_NT)
		dwOSVersion = info.dwMajorVersion*1000+info.dwMinorVersion;
}

/////////////////////////////////////////////////////////////////////////////
// CStarterApp

BEGIN_MESSAGE_MAP(CStarterApp, CWinApp)
	//{{AFX_MSG_MAP(CStarterApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStarterApp construction

CStarterApp::CStarterApp()
{
	pMainApp=this;
	GetOSShellVersion();
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CStarterApp object

CStarterApp theApp;

static void CallAll(PVV& pStart, PVV& pEnd)
{
	for(PVV* ptr=&pStart+1; ptr < &pEnd; ptr++)
#ifdef MY_DEBUG
		if(*ptr)
#endif
			(*ptr)();
}

/////////////////////////////////////////////////////////////////////////////
// CStarterApp initialization

BOOL CStarterApp::InitInstance()
{
	LPCSTR lpCmdLine = GetCommandLine();
	hMyInst=m_hInstance;
	CoInitialize(NULL);
	// 
	CSettings::Init();
	CallAll(pStartOfInit, pStartOfDone);
	if(CSettings::param<CSettings::PathTo1C>::Get().IsEmpty())
	{
		char buf[MAX_PATH];
		Get1CPath(buf);
		CSettings::param<CSettings::PathTo1C>::Set(buf);
	}
	DWORD runMode=-1;
	if(CSettings::cmdargs<CSettings::CmdRunEnterprise>())
		runMode = CSettings::cmdargs<CSettings::CmdRunMonopole>() ? runMonopole : runEnterprise;
	else if(CSettings::cmdargs<CSettings::CmdRunConfig>())
		runMode = runConfig;
	else if(CSettings::cmdargs<CSettings::CmdRunDebug>())
		runMode = runDebug;
	else if(CSettings::cmdargs<CSettings::CmdRunMonitor>())
		runMode = runMonitor;
	if(runMode != -1 && CSettings::cmdargs<CSettings::CmdIBDir>())
	{
		if(0==Run1C(runMode,
			(LPCSTR)(cstr)CSettings::cmdargs<CSettings::CmdIBDir>(),
			CSettings::GetSettings().GetUnknownCmdArg(),
			CSettings::param<CSettings::PathTo1C>::Get()))
			return FALSE;
	}

	COCDlg* pDlg = new COCDlg();
	m_pMainWnd = pDlg;
	pDlg->Create(COCDlg::IDD);
	return TRUE;
}


int CStarterApp::ExitInstance() 
{
	CallAll(pStartOfDone, pEndOfDone);
	CSettings::Done();
	CoUninitialize();
	return CWinApp::ExitInstance();
}
