// openconf_exeDlg.cpp : implementation file
#include "stdafx.h"
#include "starter.h"
#include "starterDlg.h"
#include "settings.h"
#include "baselist.h"

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CVersionInfo info(hMyInst, TRUE);
	if(info.IsLoaded())
	{
		const WORD* pFileVersion = info.GetFileVersion();
		CString text;
		text.Format(" : %i.%i.%i.%i", pFileVersion[0], pFileVersion[1], pFileVersion[2], pFileVersion[3]);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_VERSION), text);
		const CVersionInfo::SBlockInfo* pBlock = info.GetBlock(0);
		pBlock->Names2Vals.Lookup("ProductName", text);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_PROD_TITLE), text);

		HWND hList = ::GetDlgItem(m_hWnd, IDC_LIST1);
		LVCOLUMN col;
		col.mask = LVCF_TEXT | LVCF_WIDTH | LVCF_FMT;
		col.cx = 150;
		col.pszText = "";
		col.fmt = LVCFMT_RIGHT;
		ListView_InsertColumn(hList, 0, &col);
		col.pszText = "";
		col.fmt = LVCFMT_LEFT;
		ListView_InsertColumn(hList, 1, &col);

		for(DWORD idx = 0; idx < (DWORD)pBlock->vals.GetSize(); idx++)
		{
			if(!pBlock->vals[idx].IsEmpty())
			{
				LVITEM item;
				item.mask = LVIF_TEXT;
				item.pszText = (char*)(LPCSTR)pBlock->names[idx];
				item.iItem = -1;
				item.iSubItem = 0;
				item.iItem = ListView_InsertItem(hList, &item);
				item.iSubItem = 1;
				item.pszText = (char*)(LPCSTR)pBlock->vals[idx];
				ListView_SetItem(hList, &item);
			}
		}
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT1), text);
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// COCDlg dialog

COCDlg::COCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COCDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COCDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = (HICON)::LoadImage(hMyInst, (LPCSTR)IDI_MAIN, IMAGE_ICON, 16, 16, 0);// pMainApp->LoadIcon(IDR_MAINFRAME);
	m_bIsListMode = 0;
	m_pBases = new CBaseList<COCDlg>(*this);
}

void COCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COCDlg)
	DDX_Control(pDX, ID_RUN_ENTERPRISE, m_brEnterprise);
	DDX_Control(pDX, ID_RUN_MONOPOLE, m_brMonopole);
	DDX_Control(pDX, ID_RUN_CONFIG, m_brConfig);
	DDX_Control(pDX, ID_RUN_DEBUG, m_brDebug);
	DDX_Control(pDX, ID_RUN_MONITOR, m_brMonitor);
	DDX_Control(pDX, IDC_FAST_FIND, m_findbox);
	DDX_Control(pDX, IDC_STATUS, m_status);
	DDX_Control(pDX, IDC_BASESTREE, m_baseTree);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COCDlg, CDialog)
	//{{AFX_MSG_MAP(COCDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_GETMINMAXINFO()
	ON_WM_SIZE()
	ON_NOTIFY(TVN_SELCHANGED, IDC_BASESTREE, OnSelchangedBasestree)
	ON_NOTIFY(NM_DBLCLK, IDC_BASESTREE, OnDblClickBasestree)
	ON_BN_CLICKED(ID_RUN_CONFIG, OnRunConfig)
	ON_COMMAND(ID_ADD_BASEFOLDER, OnAddBasefolder)
	ON_COMMAND(ID_ADD_LINK_BASEDIR, OnAddLinkBasedir)
	ON_COMMAND(ID_ADD_LINK_BASEFOLDER, OnAddLinkBasefolder)
	ON_COMMAND(ID_ADD_LINK_LINKFOLDER, OnAddLinkLinkfolder)
	ON_COMMAND(ID_ADD_LINKFOLDER, OnAddLinkfolder)
	ON_COMMAND(ID_DELETE_LIST_LINK, OnDeleteListLink)
	ON_UPDATE_COMMAND_UI(ID_DELETE_LIST_LINK, OnUpdateDeleteListLink)
	ON_EN_CHANGE(IDC_FAST_FIND, OnChangeFastFind)
	ON_BN_CLICKED(ID_RUN_ENTERPRISE, OnRunEnterprise)
	ON_BN_CLICKED(ID_RUN_DEBUG, OnRunDebug)
	ON_BN_CLICKED(ID_RUN_MONITOR, OnRunMonitor)
	ON_BN_CLICKED(ID_RUN_MONOPOLE, OnRunMonopole)
	ON_NOTIFY(TVN_GETINFOTIP, IDC_BASESTREE, OnGetInfoTipBasestree)
	ON_UPDATE_COMMAND_UI(ID_ADD_LINKFOLDER, OnUpdateAddLinkfolder)
	ON_UPDATE_COMMAND_UI(ID_ADD_LINK_LINKFOLDER, OnUpdateAddLinkLinkfolder)
	ON_UPDATE_COMMAND_UI(ID_ADD_LINK_BASEFOLDER, OnUpdateAddLinkBasefolder)
	ON_UPDATE_COMMAND_UI(ID_ADD_LINK_BASEDIR, OnUpdateAddLinkBasedir)
	ON_UPDATE_COMMAND_UI(ID_ADD_BASEFOLDER, OnUpdateAddBasefolder)
	ON_COMMAND(ID_REFRESH, OnRefresh)
	ON_COMMAND(ID_OPEN_BASELIST, OnOpenBaselist)
	ON_COMMAND(ID_DELETE_LIST_LINK_FORCE, OnDeleteListLinkForce)
	ON_COMMAND(ID_OPEN_OBJECT, OnOpenObject)
	ON_UPDATE_COMMAND_UI(ID_OPEN_OBJECT, OnUpdateOpenObject)
	ON_COMMAND(ID_RUN_ENTERPRISE, OnRunEnterprise)
	ON_COMMAND(ID_RUN_DEBUG, OnRunDebug)
	ON_COMMAND(ID_RUN_CONFIG, OnRunConfig)
	ON_COMMAND(ID_RUN_MONITOR, OnRunMonitor)
	ON_COMMAND(ID_RUN_MONOPOLE, OnRunMonopole)
	ON_UPDATE_COMMAND_UI(ID_DELETE_LIST_LINK_FORCE, OnUpdateDeleteListLink)
	ON_COMMAND(ID_OPEN_OBJECT_PROPS, OnOpenObjectProps)
	ON_COMMAND(ID_OPEN_LINK_PROPS, OnOpenLinkProps)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COCDlg message handlers

BOOL COCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	InitAccelTable();

	m_brEnterprise.SetResID(IDB_ENTERPRISELO, IDB_ENTERPRISEHI);
	m_brMonopole.SetResID(IDB_MONO_LO, IDB_MONO_HI);
	m_brConfig.SetResID(IDB_CONFIGLO, IDB_CONFIGHI);
	m_brDebug.SetResID(IDB_DEBUGLO, IDB_DEBUGHI);
	m_brMonitor.SetResID(IDB_MONITORLO, IDB_MONITORHI);

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, " OpenV7");
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon((HICON)::LoadImage(hMyInst, (LPCSTR)IDI_MAIN, IMAGE_ICON, 32, 32, 0), TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_tlb.Create(this, IDR_BASEWORK, IDB_TOOLBAR_HI, CRect(0, 0, 200, 20), 100);
	m_baseTree.SendMessage(TVM_SETIMAGELIST, TVSIL_NORMAL, (LPARAM)m_IconList.hList);
	
	LayoutControls();
	FillTree();

	RECT rect;
	rect.bottom = CSettings::param<CSettings::Bottom>::Get();
	if(rect.bottom>-1)
	{
		rect.left = CSettings::param<CSettings::Left>::Get();
		rect.top  = CSettings::param<CSettings::Top>::Get();
		rect.right= CSettings::param<CSettings::Right>::Get();
		CRect rcScreen;
		::GetWindowRect(::GetDesktopWindow(), rcScreen);
		if(rect.bottom > rcScreen.bottom)
			rect.bottom = rcScreen.bottom;
		if(rect.right > rcScreen.right)
			rect.right = rcScreen.right;
		if(rect.left <0)
			rect.left = 0;
		if(rect.top<0)
			rect.top = 0;
		if(rect.bottom - rect.top > 640)
			rect.bottom = rect.top + 640;
		if(rect.right - rect.left > 800)
			rect.right = rect.left + 800;
		MoveWindow(&rect);
	}

	m_baseTree.SetFocus();
	InitToolTips();

	UINT defID = ID_RUN_ENTERPRISE;

	if(CSettings::cmdargs<CSettings::CmdRunEnterprise>() &&
		CSettings::cmdargs<CSettings::CmdRunMonopole>())
		defID = ID_RUN_MONOPOLE;
	else if(CSettings::cmdargs<CSettings::CmdRunConfig>())
		defID = ID_RUN_CONFIG;
	else if(CSettings::cmdargs<CSettings::CmdRunDebug>())
		defID = ID_RUN_DEBUG;
	else if(CSettings::cmdargs<CSettings::CmdRunMonitor>())
		defID = ID_RUN_MONITOR;

	SetDefID(defID);

	CString lastBase = CSettings::param<CSettings::LastBase>::Get();
	if(!lastBase.IsEmpty())
	{
		CString buf;
		FindDataItem(m_pBases->GetBases(), lastBase, buf);
	}

	return FALSE;
}

void COCDlg::FillTree(data_item* pCurItem /*= NULL*/)
{
	m_baseTree.SetRedraw(FALSE);
	m_baseTree.DeleteAllItems();

	FillGroup(m_pBases->GetBases(), TVI_ROOT);

	if(m_bIsListMode)
	{
		m_baseTree.SortChildren(NULL);
		SetComment("");
	}
	else
	{
		OrderTree();
		if(pCurItem)
		{
			m_baseTree.Select(pCurItem->m_guiItem, TVGN_CARET);
			m_baseTree.Select(pCurItem->m_guiItem, TVGN_FIRSTVISIBLE);
		}
		else
		{
			HTREEITEM first = m_baseTree.GetNextItem(TVI_ROOT, TVGN_CHILD);
			if(first)
			{
				m_baseTree.Select(first, TVGN_CARET);
				m_baseTree.Expand(first, TVE_EXPAND);
			}
		}
	}
	m_baseTree.SetRedraw(TRUE);
	if(!m_baseTree.GetNextItem(TVI_ROOT, TVGN_CARET))
	{
		SetRunModes(0);
		SetOperation(0);
	}
}

void COCDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COCDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COCDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void COCDlg::OnDestroy() 
{
	delete m_pBases;
	DestroyAcceleratorTable(m_hAccel);
	CDialog::OnDestroy();
}

static void EndApp(COCDlg* ptr)
{
	CRect rect;
	ptr->GetWindowRect(rect);
	CSettings::param<CSettings::Left>::Set(rect.left);
	CSettings::param<CSettings::Top>::Set(rect.top);
	CSettings::param<CSettings::Right>::Set(rect.right);
	CSettings::param<CSettings::Bottom>::Set(rect.bottom);

	pMainApp->m_pMainWnd=NULL;
	pMainApp->PostThreadMessage(WM_QUIT, 0, 0);
	delete ptr;
}

void COCDlg::OnCancel()	{EndApp(this);}
void COCDlg::OnOK()		{EndApp(this);}

void COCDlg::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	CDialog::OnGetMinMaxInfo(lpMMI);
	lpMMI->ptMinTrackSize.x=400;
	lpMMI->ptMinTrackSize.y=350;
	lpMMI->ptMaxTrackSize.x=800;
	lpMMI->ptMaxTrackSize.y=600;
}

void COCDlg::LayoutControls()
{
	if(!m_brEnterprise.m_hWnd)
		return;
	CRect rcClient;
	GetClientRect(rcClient);

	int tbHeight=HIWORD(m_tlb.GetButtonSize());
	CRect rect;
	m_brEnterprise.GetWindowRect(rect);

	m_tlb.MoveWindow(3, 2, rcClient.right, tbHeight);
	
	CWnd* pStatus=GetDlgItem(IDC_STATUS);
	CRect rcStatus;
	pStatus->GetWindowRect(rcStatus);
	pStatus->MoveWindow(3, rcClient.bottom-3-(rcStatus.bottom - rcStatus.top), rcClient.right-6, rcStatus.Height());

	int nWidth=rect.Width(),
		nHeight=rect.Height(),
		nLeft=rcClient.right-3-nWidth,
		nTop=tbHeight + 4;

	if(m_bIsListMode)
	{
		CRect rcFind;
		m_findbox.GetWindowRect(rcFind);
		DWORD fndHeight = rcFind.bottom - rcFind.top;
		m_findbox.MoveWindow(3, nTop, nLeft-6, fndHeight);
		m_baseTree.MoveWindow(3, nTop + fndHeight, nLeft-6, rcClient.bottom-3-(rcStatus.bottom - rcStatus.top) - nTop - 3 - fndHeight);
	}
	else
		m_baseTree.MoveWindow(3, nTop, nLeft - 6, rcClient.bottom - 3 - (rcStatus.bottom - rcStatus.top) - nTop - 3);
	
	m_brEnterprise.MoveWindow(nLeft, nTop, nWidth, nHeight);
	nTop+=nHeight;
	m_brMonopole.MoveWindow(nLeft, nTop, nWidth, nHeight);
	nTop+=nHeight;
	m_brConfig.MoveWindow(nLeft, nTop, nWidth, nHeight);
	nTop+=nHeight;
	m_brDebug.MoveWindow(nLeft, nTop, nWidth, nHeight);
	nTop+=nHeight;
	m_brMonitor.MoveWindow(nLeft, nTop, nWidth, nHeight);
}

void COCDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	LayoutControls();
}

void COCDlg::OnSelchangedBasestree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	*pResult = 1;

	data_item* pItem = reinterpret_cast<data_item*>(pNMTreeView->itemNew.lParam);
	if(pItem)
		pItem->OnSelect(*this);
}

void COCDlg::OnAddBasefolder() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->CreateBaseDir(*this);
}

void COCDlg::OnAddLinkBasedir() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->CreateLink2BaseDir(*this);
}

void COCDlg::OnAddLinkBasefolder() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->CreateLink2BasesFolder(*this);
}

void COCDlg::OnAddLinkLinkfolder() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->CreateLink2LinkFolder(*this);
}

void COCDlg::OnAddLinkfolder() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->CreateLinkFolder(*this);
}

void COCDlg::OnUpdateDeleteListLink(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(0 != (m_wEnabledOperations & idDeleteLink));
}

void COCDlg::OnDeleteListLink() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->DeleteLink(*this, FALSE);
}

void COCDlg::OnDeleteListLinkForce() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->DeleteLink(*this, TRUE);
}

void SplitStr2Array(cstr str,CStringArray& arr,char delim)
{
	if(str.IsEmpty())
		return;
	LPCTSTR pRead=str,pStart=pRead;
	for(;;)
	{
		while(*pRead && *pRead!=delim)
			pRead++;
		CString key=CString(pStart,pRead-pStart);
		arr.Add(key);
		if(!*pRead)
			break;
		pStart=++pRead;
	}
}

void COCDlg::OnChangeFastFind()
{
	if(m_bIsListMode==2)
		return;
	CString text;
	m_findbox.GetWindowText(text);
	BOOL bNeedReFill = FALSE;
	
	HTREEITEM curItem = m_baseTree.GetNextItem(TVI_ROOT, TVGN_CARET);
	data_item* pCurItem = curItem ? reinterpret_cast<data_item*>(m_baseTree.GetItemData(curItem)) : NULL;
	
	if(text.IsEmpty())
	{
		if(m_bIsListMode)
		{
			m_bIsListMode = 0;
			m_baseTree.ModifyStyle(TVS_FULLROWSELECT, TVS_LINESATROOT|TVS_HASLINES);
			m_baseTree.SetFocus();
			bNeedReFill = TRUE;
			m_findbox.ShowWindow(SW_HIDE);
			LayoutControls();
		}
	}
	else
	{
		text.MakeLower();
		m_strFastFind.RemoveAll();
		SplitStr2Array(text, m_strFastFind, ' ');
		bNeedReFill = TRUE;
		if(!m_bIsListMode)
		{
			m_bIsListMode = 1;
			m_baseTree.ModifyStyle(TVS_LINESATROOT|TVS_HASLINES, TVS_FULLROWSELECT);
			m_findbox.ShowWindow(SW_SHOW);
			LayoutControls();
		}
	}
	if(bNeedReFill)
		FillTree(pCurItem);
}

BOOL COCDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_KEYDOWN && pMsg->hwnd == m_findbox.m_hWnd && pMsg->wParam == VK_DELETE)
		return FALSE;
	if(TranslateAccelerator(m_hWnd, m_hAccel, pMsg))
		return TRUE;
	if(pMsg->message == WM_KEYDOWN)
	{
		if(pMsg->hwnd == m_findbox.m_hWnd &&
			(pMsg->wParam == VK_UP || pMsg->wParam == VK_DOWN))
		{
			if(m_bIsListMode)
			{
				HTREEITEM curItem = m_baseTree.GetNextItem(TVI_ROOT, TVGN_CARET);
				if(curItem)
					curItem = m_baseTree.GetNextItem(curItem, pMsg->wParam == VK_UP ? TVGN_PREVIOUS : TVGN_NEXT);
				else
					curItem = m_baseTree.GetNextItem(TVI_ROOT, TVGN_CHILD);
				if(curItem)
				{
					m_baseTree.Select(curItem, TVGN_CARET);
					m_bIsListMode = 2;
					m_findbox.SetWindowText(m_baseTree.GetItemText(curItem));
					m_findbox.SetSel(0, -1);
					m_bIsListMode = 1;
				}
			}
			else
				m_baseTree.SetFocus();
			return TRUE;
		}
	}
	else if(pMsg->hwnd == m_baseTree.m_hWnd && pMsg->message == WM_CHAR)
	{
		m_findbox.SetFocus();
		pMsg->hwnd = m_findbox.m_hWnd;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

int CALLBACK COCDlg::CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	data_item* p1 = reinterpret_cast<data_item*>(lParam1);
	data_item* p2 = reinterpret_cast<data_item*>(lParam2);
	int diff = p1->IsItBase() - p2->IsItBase();
	if(diff)
		return diff;
	return p1->GetTitle().CompareNoCase(p2->GetTitle());
}

void COCDlg::OrderTree(HTREEITEM hParent/* = TVI_ROOT*/)
{
	HTREEITEM child = m_baseTree.GetNextItem(hParent, TVGN_CHILD);
	if(child)
	{
		while(child)
		{
			OrderTree(child);
			child = m_baseTree.GetNextItem(child, TVGN_NEXT);
		}
		TVSORTCB tvs;
		tvs.hParent = hParent;
		tvs.lpfnCompare = &COCDlg::CompareFunc;
		m_baseTree.SortChildrenCB(&tvs);
	}
}

void COCDlg::OrderChild(HTREEITEM hParent/* = TVI_ROOT*/)
{
	TVSORTCB tvs;
	tvs.hParent = hParent;
	tvs.lpfnCompare = &COCDlg::CompareFunc;
	m_baseTree.SortChildrenCB(&tvs);
}

void COCDlg::OnRunEnterprise() 
{
	Run1C(idRunEnterprise);
}

void COCDlg::OnRunMonopole() 
{
	Run1C(idRunMonopole);
}

void COCDlg::OnRunConfig() 
{
	Run1C(idRunConfig);
}

void COCDlg::OnRunDebug() 
{
	Run1C(idRunDebug);
}

void COCDlg::OnRunMonitor() 
{
	Run1C(idRunMonitor);
}

static void GetAccelString(ACCEL* pAccel, UINT cmd, DWORD dwAccCount, CString& text)
{
	for(DWORD i=0;i<dwAccCount;i++)
	{
		if(pAccel->cmd == cmd)
		{
			text = " (";
			if(pAccel->fVirt & FCONTROL)
				text+="Ctrl + ";
			if(pAccel->fVirt & FALT)
				text+="Alt + ";
			if(pAccel->fVirt & FSHIFT)
				text+="Shift + ";
			char buf[30];
			DWORD sc = MapVirtualKey(pAccel->key, 0)<<16;
			if(pAccel->key < VK_NUMPAD0/* || pAccel->key > VK_DIVIDE*/)
				sc |= 1<<24;
			if(GetKeyNameText(sc, buf, 29))
			{
				text+=buf;
				text+=")";
			}
			else
				text.Empty();
			return;
		}
		pAccel++;
	}
	text.Empty();
}

void COCDlg::InitToolTips()
{
	HWND hToolTip = (HWND)m_tlb.SendMessage(TB_GETTOOLTIPS);

	TOOLINFO ti;
	ti.cbSize	=sizeof(ti);
	ti.uFlags	=TTF_IDISHWND|TTF_SUBCLASS;
	ti.hwnd		=m_hWnd;
	ti.hinst	=hMyInst;

	DWORD dwAccCount = CopyAcceleratorTable(m_hAccel, NULL, 0);
	ACCEL* pAccel = new ACCEL[dwAccCount];
	CopyAcceleratorTable(m_hAccel, pAccel, dwAccCount);
	
	int nBtns = m_tlb.GetButtonCount();
	for(int i = 0; i<nBtns; i++)
	{
		TBBUTTON tbb;
		m_tlb.GetButton(i, &tbb);
		CString tt, hk;
		m_tlb.GetToolTip(tbb.idCommand, tt);
		if(!tt.IsEmpty())
		{
			GetAccelString(pAccel, tbb.idCommand, dwAccCount, hk);
			if(!hk.IsEmpty())
				m_tlb.SetToolTip(tbb.idCommand, tt + hk);
		}
	}

	HWND hWnd = ::GetWindow(m_hWnd, GW_CHILD);
	while(hWnd)
	{
		UINT id = ::GetDlgCtrlID(hWnd);
		char buf[MAX_PATH];
		if(LoadString(hMyInst, id, buf, MAX_PATH))
		{
			CString hotkey;
			GetAccelString(pAccel, id, dwAccCount, hotkey);
			ti.uId		=(UINT)hWnd;
			ti.lpszText =(char*)(LPCSTR)(CString(buf) + hotkey);
			::SendMessage(hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);
		}
		hWnd = ::GetWindow(hWnd, GW_HWNDNEXT);
	}
	delete [] pAccel;
}

void COCDlg::OnGetInfoTipBasestree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NMTVGETINFOTIP* pInfoTip = (NMTVGETINFOTIP*)pNMHDR;
	*pResult = 1;
	data_item* pItem = reinterpret_cast<data_item*>(pInfoTip->lParam);
	if(pItem)
	{
		CString text;
		pItem->GetToolTip(text);
		strncpy(pInfoTip->pszText, text, pInfoTip->cchTextMax);
	}
}

static ACCEL* GetAccel(ACCEL* pAccel, UINT cmd, DWORD dwCount)
{
	for(DWORD i=0;i<dwCount;i++)
	{
		if(pAccel->cmd == cmd)
			return pAccel;
		pAccel++;
	}
	return NULL;
}

void COCDlg::InitAccelTable()
{
	m_hAccel = LoadAccelerators(hMyInst, (LPCSTR)IDR_HOT_KEY);
	DWORD dwAccCount = CopyAcceleratorTable(m_hAccel, NULL, 0);
	ACCEL* pAccel = new ACCEL[dwAccCount];
	CopyAcceleratorTable(m_hAccel, pAccel, dwAccCount);
	static const int opt2cmd[]={
		ID_RUN_ENTERPRISE,
		ID_RUN_MONOPOLE,
		ID_RUN_CONFIG,
		ID_RUN_DEBUG,
		ID_RUN_MONITOR,
	};
	CSettings& stt = CSettings::GetSettings();
	for(int i = CSettings::RunEnterprise::idx ;i<=CSettings::RunMonitor::idx; i++)
	{
		ACCEL* pHotKey = GetAccel(pAccel, opt2cmd[i - CSettings::RunEnterprise::idx], dwAccCount);
		if(pHotKey)
		{
			DWORD cmd = stt.GetDword(i);
			if(cmd == -1)
				stt.SetDword(i, (pHotKey->fVirt<<16) | pHotKey->key);
			else
			{
				pHotKey->fVirt = (BYTE)(cmd>>16);
				pHotKey->key = (WORD)cmd;
			}
		}
	}
	DestroyAcceleratorTable(m_hAccel);
	m_hAccel = CreateAcceleratorTable(pAccel, dwAccCount);
	delete [] pAccel;
}

void COCDlg::OnUpdateAddLinkfolder(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_wEnabledOperations & idCreateLinkFolder);
}

void COCDlg::OnUpdateAddLinkLinkfolder(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_wEnabledOperations & idCreateLink2LinkFolder);
}

void COCDlg::OnUpdateAddLinkBasefolder(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_wEnabledOperations & idCreateLink2BasesDir);
}

void COCDlg::OnUpdateAddLinkBasedir(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_wEnabledOperations & idCreateLink2BaseDir);
}

void COCDlg::OnUpdateAddBasefolder(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_wEnabledOperations & idCreateBaseDir);
}

void COCDlg::OnRefresh() 
{
	m_pBases->ReLoad(*this);
	FillTree();
}

void COCDlg::OnOpenBaselist() 
{
	ShellExecute(m_hWnd, "explore", m_pBases->GetBaseListLocation(), NULL, NULL, SW_SHOWNORMAL);
}

COCDlg::data_item* COCDlg::GetCurrentItem()
{
	HTREEITEM item = m_baseTree.GetNextItem(TVI_ROOT, TVGN_CARET);
	if(item)
		return reinterpret_cast<data_item*>(m_baseTree.GetItemData(item));
	return NULL;
}

void COCDlg::OnOpenObject() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->OpenObject(*this);
}

void COCDlg::OnUpdateOpenObject(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_wEnabledOperations & idOpenObject);
}

void COCDlg::Run1C(WORD wMode)
{
	if(!(m_wEnabledModes & wMode))
		return;
	data_item* pItem = GetCurrentItem();
	if(pItem)
	{
		DWORD err = pItem->RunBase(wMode);
		if(!err)
		{
			CString strLastBase;
			pItem->ToString(strLastBase);
			CSettings::param<CSettings::LastBase>::Set(strLastBase);
			EndApp(this);
		}
		else
			AfxMessageBox(CString("  : ") + GetErrDescription(err));
	}
}

void COCDlg::OnOpenObjectProps() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->OpenProps(*this);
}

void COCDlg::OnOpenLinkProps() 
{
	data_item* pItem = GetCurrentItem();
	if(pItem)
		pItem->OpenLinkProps(*this);
}

void COCDlg::OnDblClickBasestree(NMHDR* pNMHDR, LRESULT* pResult)
{
	*pResult = 1;
	UINT defID = GetDefID();
	SendMessage(WM_COMMAND, defID);
}

BOOL COCDlg::FindDataItem(data_item* pParent, cstr strId, CString& buf)
{
	for(data_item::iter it = pParent->Child(); it ;++it)
	{
		it->ToString(buf);
		if(strId == buf)
		{
			m_baseTree.Select(it->m_guiItem, TVGN_CARET);
			m_baseTree.Select(it->m_guiItem, TVGN_FIRSTVISIBLE);
			return TRUE;
		}
		if(FindDataItem(it, strId, buf))
			return TRUE;
	}
	return FALSE;
}
