Attribute VB_Name = "DlgStream"
Option Explicit

Public Function GetDefaultStringArr(CtrlType) As String()
    Dim GetDefaultString As String

    Select Case CtrlType
        Case "Button"
            GetDefaultString = "{"""",""BUTTON"",""1342177291"",""8"",""22"",""41"",""13"",""0"",""0"",""4260"","""","""","""",""0"",""U"",""0"",""0"",""0"",""0"",""0"","""","""","""",""0"",""-11"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""MS Sans Serif"",""-1"",""-1"",""0"","""",""{""""0"""",""""0""""}""}"
        Case "CheckBox"
            GetDefaultString = "{"""",""CHECKBOX"",""1342177283"",""7"",""39"",""43"",""13"",""0"",""0"",""4159"","""","""","""",""0"",""U"",""0"",""0"",""0"",""0"",""0"","""","""","""",""0"",""-11"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""MS Sans Serif"",""-1"",""-1"",""0"","""",""{""""0"""",""""0""""}""}"
        Case "Label"
            GetDefaultString = "{"""",""STATIC"",""1342177280"",""7"",""126"",""63"",""13"",""0"",""0"",""4154"","""","""","""",""0"",""U"",""0"",""0"",""0"",""0"",""192"","""","""","""",""0"",""-11"",""0"",""0"",""0"",""400"",""0"",""0"",""0"",""204"",""1"",""2"",""1"",""34"",""MS Sans Serif"",""-1"",""-1"",""0"","""",""{""""0"""",""""0""""}""}"
        Case "Text"
            GetDefaultString = "{"""",""1CEDIT"",""1350565888"",""7"",""144"",""66"",""13"",""0"",""0"",""4153"","""","""","""",""-1"",""S"",""10"",""0"",""0"",""0"",""0"","""","""","""",""0"",""-11"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""0"",""MS Sans Serif"",""-1"",""-1"",""0"","""",""{""""0"""",""""0""""}""}"
    End Select

Children:
    GetDefaultStringArr = Split(Mid$(GetDefaultString, 3), """,""")
End Function

Public Sub SetType(ByRef ControlArr() As String, ByVal ObjType As String)
    Dim ObjKind As String
    Dim ObjTypeMain As String
    Dim CntType As String
    Dim CntKind As String
    Dim CntLength As String
    Dim CntTochn As String
    Dim CntView As String
    Dim NumberMD As Integer

    If InStr(ObjType, ".") = 0 Then
        ObjKind = ""
        ObjTypeMain = ObjType
    Else
        ObjKind = Mid$(ObjType, InStr(ObjType, ".") + 1)
        ObjTypeMain = Left$(ObjType, InStr(ObjType, ".") - 1)
    End If
    
    ObjTypeMain = UCase(ObjTypeMain)
    
    CntKind = "0"
    CntLength = "0"
    CntTochn = "0"
    CntView = "1CEDIT"

    Select Case ObjTypeMain
        Case ""
            CntType = "N"
            CntLength = "19"
            CntTochn = "5"
            CntView = "BMASKED"

        Case ""
            CntType = "S"
            CntLength = 0 ' 255

        Case ""
            CntType = "D"
            CntView = "BMASKED"

        Case ""
            CntType = "T"
            CntView = "BMASKED"

        Case ""
            CntType = "B"
            NumberMD = 1
            CntView = "BMASKED"

        Case ""
            CntType = "O"
            NumberMD = 2
            CntView = "BMASKED"

        Case ""
            CntType = "E"
            NumberMD = 4
            CntView = "BMASKED"

        Case Else
            CntType = "U"
    
    End Select

    If NumberMD > 0 And ObjKind <> "" Then
        Dim MainObj As OpenConf.TaskDef
        Dim ObjArray As OpenConf.MetaDataObjArray
        Dim I As Integer

        ObjKind = UCase(ObjKind)
        Set MainObj = MetaData.TaskDef
        Set ObjArray = MainObj.Childs(NumberMD)
        For I = 0 To ObjArray.Count - 1
            If UCase(ObjArray(I).Name) = ObjKind Then
                CntKind = ObjArray(I).ID
                Exit For
            End If
        Next
    End If

    ControlArr(1) = CntView
    ControlArr(14) = CntType
    ControlArr(15) = CntLength
    ControlArr(16) = CntTochn
    ControlArr(17) = CntKind
End Sub
