// ModuleString.cpp: implementation of the CModuleString class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ModuleString.h"
#include "..\vis1cpp.h"
#include <atlconv.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#import "C:\Program Files\1Cv77\BIN\zlibeng.dll" no_namespace
//#import "C:\Program Files\1Cv77\Bin25\BIN\zlibeng.dll" no_namespace
//#import "C:\Program Files\1C\BIN25\Bin\zlibeng.dll" no_namespace
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//CBLModule7

bool CModuleString::LoadModule(const CString& strFileName_in)
{
	CString strFileName  = (LPCSTR)strFileName_in;
	  CString strTemp = strFileName; // artbear
	  strTemp.MakeLower();
  if (strTemp.Find(".ert") != -1) //       
  {    
    IStoragePtr pStgRoot;
    IStorage* pStorage = NULL;
    HRESULT hr;
    USES_CONVERSION;
    hr = ::StgOpenStorage(
            T2COLE(strFileName),
            NULL,
            STGM_READ | STGM_SHARE_DENY_WRITE,
            NULL,
            0,
            &pStorage);

    if (FAILED(hr))
    {	//
      CString StrError;
      StrError = "   : ";
      StrError += strFileName;
      pBkEndUI->DoMessageLine(StrError, mmBlackErr);	
      return false;
    }              
    pStgRoot.Attach(pStorage, false);

    IStreamPtr pStream;
    IStream *pIStr = NULL;
    hr = pStgRoot->OpenStream(T2COLE("MD Programm text"),0,STGM_READ | STGM_SHARE_EXCLUSIVE,0,&pIStr);
    if( FAILED(hr) ) 
    {
      pBkEndUI->DoMessageLine("failed IStorage::OpenStream", mmBlackErr);	            
      return false;        
    }
    pStream.Attach(pIStr, false);    

    IStreamPtr pStreamOut;
    pIStr = NULL;
    if (S_OK == CreateStreamOnHGlobal(NULL, TRUE, &pIStr))
    {     
      pStreamOut.Attach(pIStr, false);
      try 
      {
        IzlibEnginePtr iLibEngine;
        iLibEngine.CreateInstance(L"V75.zlibEngine");
      
        hr = iLibEngine->pkDecompress(pStream, pStreamOut);            
        if (FAILED(hr))
        {
          pBkEndUI->DoMessageLine("error iLibEngine->pkDecompress", mmBlackErr);          
          return false;
        }          
        else
        {
          HGLOBAL hGlobal    = NULL;
          LPVOID lpMemStream = NULL;
          
          STATSTG St;
          pStreamOut->Stat(&St, STATFLAG_NONAME);
          
          ULONG cbStreamSizeOut = St.cbSize.LowPart;

          GetHGlobalFromStream(pStreamOut, &hGlobal);
          if (hGlobal != NULL)
          {
            lpMemStream = GlobalLock(hGlobal);                  
            LPTSTR lpStr = GetBufferSetLength(cbStreamSizeOut);
            memcpy(&lpStr[0], lpMemStream, cbStreamSizeOut);            
            GlobalUnlock(hGlobal);
            GlobalFree(hGlobal);
          }
          else
          {
            pBkEndUI->DoMessageLine("hGlobal == NULL", mmBlackErr);	                            
            return false;
          }
        }

      } 
      catch (_com_error&) 
      {
        pBkEndUI->DoMessageLine("catch (_com_error& er) ", mmBlackErr);
      }                  
    }
    else
    {
      pBkEndUI->DoMessageLine("error in CreateStreamOnHGlobal", mmBlackErr);    
      return false; 
    }        
    return true;    
  }
  else
  {
    //pBkEndUI->DoMessageLine(strFileName, mmMetaData);    
    const_cast<CString*>(&strFileName)->MakeUpper();
    
		int npos = strFileName.Find("@MD");
		if(npos != -1)
		{
			bool res = false;
			CString nameRep = strFileName.Left(npos);
			CMetaDataCont *pMD = GetMetaData();  
			if(pMD)
			{
				CMetaDataObj* pObj=(CMetaDataObj*)pMD->GetCalcVarDef(nameRep);
				if(pObj)
				{
					long id=pObj->GetID();
					CTypedCont* pCont=NULL;
					CString text;
					CConfigCont::IDToPath(id,"CalcVar",text,&pCont,FALSE);
					if(pCont)
					{
						CTextDocument* pText = (CTextDocument*)pCont->GetTextDocument();        
						pText->GetText(*this);           
						res = true;
					}
				}
			}
			return res;
		}
		else
		{
			CFile ComponentFile;
			if (ComponentFile.Open(strFileName, CFile::modeRead))
			{
				DWORD dwLength = ComponentFile.GetLength();
				LPTSTR buff = GetBuffer(dwLength);
				ComponentFile.Read(buff, dwLength);
				ReleaseBuffer(dwLength);
				ComponentFile.Close();
				return true;
			}
			else
			{
				CString StrError;
				StrError = "   : ";
				StrError += strFileName;
				pBkEndUI->DoMessageLine(StrError, mmBlackErr);	
				return false;
			}
		}
	}
}

int CModuleString::getOffsetLines()
{
	return OffsetLines;
};

int CModuleString::DeleteWithLineCountTo(int posBegin)
{
	int Result = 0;
	
	CString TopOfTheModule = Left(posBegin);
	while (!TopOfTheModule.IsEmpty())
	{
		int pos = TopOfTheModule.Find("\n");
		if (pos != -1)
		{
			Result++;
			TopOfTheModule.Delete(0, pos+1); // +1     \n
		}
	}
	
	Delete(0, posBegin);

	return Result;
}

//      
//
//    //# ClassBegin   //# ClassEnd , 
//	    
//     
//
void CModuleString::CropModuleToClass(const CString& strClassName)
{
	int posBegin = 0;
	int posEnd = GetLength();

	int findBegin = Find("//# ClassBegin "+ strClassName+";");
	int findEnd = Find("//# ClassEnd " + strClassName+";");

	if (findBegin != -1)
	{
		//pBkEndUI->DoMessageLine("Begin of "+strClassName+" found", mmBlackErr);
		posBegin = findBegin;
	}
	if (findEnd != -1)
	{
		//pBkEndUI->DoMessageLine("End of "+strClassName+" found", mmBlackErr);
		posEnd = findEnd;
	}

	Delete(posEnd, GetLength() - posEnd);
	OffsetLines = DeleteWithLineCountTo(posBegin); //     CModuleParser

}

//   ,        //# ClassBegin  //# ClassEnd
//          
// ,  //#         
//
//#  ClassBegin  
//#   ClassEnd  
//
bool CModuleString::DivideTextOnClasses(CMapStringToString* pMap)
{
	bool bRes = false;

	LPCSTR szClassBegin = "ClassBegin";
	LPCSTR szClassEnd = "ClassEnd";
	if (-1 == Find(szClassBegin))
		return bRes;

	LPCSTR szBeginPrepoccessorDef = "//#";
	const int iCountBeginDef = 3;
	LPCSTR szDelim = " \t\r\n;";

	LPSTR szCurrStr = LockBuffer();
	szCurrStr = strstr(szCurrStr, szBeginPrepoccessorDef);
	if (!szCurrStr)
	{
		ReleaseBuffer();
		return NULL;
	}

	LPSTR szSaveCurrStr = szCurrStr;
	
	LPSTR szAllocString = (char*)malloc(strlen(szCurrStr) + 1);
	strcpy(szAllocString, szCurrStr);
	LPSTR szFind = NULL;

	while(szCurrStr) // "//#"
	{

		szCurrStr += iCountBeginDef;
		szFind = szAllocString + (szCurrStr - szSaveCurrStr);

		LPCSTR szToken1 = strtok(szFind, szDelim);
	
		if (!strstr(szToken1, szClassBegin))
		{
			szCurrStr = strstr(szCurrStr, szBeginPrepoccessorDef);
			szFind = szAllocString + (szSaveCurrStr - szSaveCurrStr);
			continue;
		}

		LPCSTR szTokenClassName1 = strtok(NULL, szDelim);
		if (!szTokenClassName1)
		{
			szCurrStr = strstr(szCurrStr, szBeginPrepoccessorDef);
			szFind = szAllocString + (szSaveCurrStr - szSaveCurrStr);
			continue;
		}
		//  szTokenClassName1 =  

		LPSTR szEndOfLine1 = strstr(szCurrStr, "\r\n");
		// TODO    
		if (!szEndOfLine1)
		{
			szCurrStr = strstr(szCurrStr, szBeginPrepoccessorDef);
			szFind = szAllocString + (szSaveCurrStr - szSaveCurrStr);
			continue;
		}

		LPSTR szBeginOfClass = szEndOfLine1+1; //   

		LPSTR szCurrStrEnd = strstr(szBeginOfClass, szBeginPrepoccessorDef);
		LPSTR szSaveCurrStrEnd = szCurrStrEnd;

		LPSTR szAllocStringEnd = (char*)malloc(strlen(szCurrStrEnd) + 1);
		strcpy(szAllocStringEnd, szCurrStrEnd);
		LPSTR szFindEnd = NULL;

		LPSTR szSaveEndOfClass = NULL;
		
		while(szCurrStrEnd)
		{
			szSaveEndOfClass = szCurrStrEnd;

			szCurrStrEnd += iCountBeginDef;
			szFindEnd = szAllocStringEnd + (szCurrStrEnd - szSaveCurrStrEnd);

			LPCSTR szToken1 = strtok(szFindEnd, szDelim);
			if (!strstr(szToken1, szClassEnd))
			{
				szCurrStrEnd = strstr(szCurrStrEnd, szBeginPrepoccessorDef);
				szFindEnd = szAllocStringEnd + (szCurrStrEnd - szSaveCurrStrEnd);
				continue;
			}

			LPCSTR szTokenClassName2 = strtok(NULL, szDelim);
			if (!szTokenClassName2)
			{
				szCurrStrEnd = strstr(szCurrStrEnd, szBeginPrepoccessorDef);
				szFindEnd = szAllocStringEnd + (szCurrStrEnd - szSaveCurrStrEnd);
				continue;
			}
			//  szTokenClassName2 -  
			if(!strstr(szTokenClassName1, szTokenClassName2)) //   
			{
				RuntimeError("      %s ", szTokenClassName1);
				//szCurrStrEnd = strstr(szCurrStrEnd, szBeginPrepoccessorDef);
				//szFindEnd = szAllocStringEnd + (szCurrStrEnd - szSaveCurrStrEnd);
				//continue;
			}
			
			LPSTR szEndOfLine2 = strstr(szCurrStrEnd, "\r\n");
			if (!szEndOfLine2)
			{
				// TODO    
				szCurrStrEnd = strstr(szCurrStrEnd, szBeginPrepoccessorDef);
				szFindEnd = szAllocStringEnd + (szCurrStrEnd - szSaveCurrStrEnd);
				continue;
			}

			szCurrStr = szEndOfLine2+1;
			break;
		}
		
		free(szAllocStringEnd);

		//   
		LPSTR szEndOfClass = szSaveEndOfClass-1;

		int iCount = szEndOfClass - szBeginOfClass + 1;

		CString strClassSource;
		LPSTR szClassSource = strClassSource.GetBufferSetLength(iCount);
		strncpy(szClassSource, szBeginOfClass, iCount);
		strClassSource.ReleaseBuffer(-1);

//  LogErr("  %s-------------------\n<<<<<%s>>>>>\n-----------------------", 
//  	   szTokenClassName1, szClassSource);

		CString s;
		if (pMap->Lookup(szTokenClassName1, s))
			RuntimeError(" %s      ", szTokenClassName1);

		pMap->SetAt(szTokenClassName1, szClassSource);

		szCurrStr = strstr(szCurrStr, szBeginPrepoccessorDef);
		
		bRes = true;
	}
	
	free(szAllocString);

	ReleaseBuffer();

	return bRes;

}

bool CModuleString::LoadModule(const CString& strFileName, const CString& strClassName)
{
	if (LoadModule(strFileName))
	{
		if (!strClassName.IsEmpty())
			CropModuleToClass(strClassName);
		
		return true;
	}

	return false;
}
