// CPPView.cpp : implementation file

#include "stdafx.h"
#include "stdafx.h"
#include "vis1cpp.h"
#include "CPPdoc.h"
#include "CPPView.h"
#include ".\1cpp\preprocessor.h"
#include ".\1cpp\MetaDataOfClasses.h"
#include "InfoWrcSpace.h"
#include "mytextdoc.h"
#include "classinfo.h"
#include "deffileinfo.h"
#include "resource.h"
#include "syntax.h"
#include "MyLock.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
CString PrintRTC(CObject*);

#define WM_REFRESH_EDIT_LOCK	WM_USER+51

/////////////////////////////////////////////////////////////////////////////
// CCPPView

IMPLEMENT_DYNCREATE(CCPPView, CTreeView)
CCPPView* CCPPView::m_pView=NULL;
CImageList CCPPView::m_ImageList;
HACCEL CCPPView::m_HotKeys;

CCPPView::CCPPView()
{
	static bool first=true;
	m_pView=this;
	m_click=CPoint(0,0);
	m_pRootData=NULL;
	if(first)
	{
		CImageList& pList=CCPPView::m_ImageList;
		pList.Create(16,16,ILC_COLOR|ILC_MASK,14,1);
		HINSTANCE hRes=GetModuleHandle("1crcrus.dll");
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_WRCCPACE));	// TYPE_WRCSPACE_FOLDER	
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_DEFFILE));	// TYPE_DEF_FILE_FOLDER
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_CLASS_LOCK));	// TYPE_CLASS_FOLDER		// ..
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_CLASS_OWNLOCK));	// TYPE_CLASS_FOLDER	// ..
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_CLASS));	// TYPE_CLASS_FOLDER		
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_BASECLASSES));	// TYPE_BASE_CLASS_FOLDER	
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_DECLPROC));	// TYPE_DECLARED_PROC		
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_OPENMET));	// TYPE_MODULE_PROC_EXPORT	
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_PRIVMET));	// TYPE_MODULE_PROC_PRIVATE
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_OPENMEMB));	// TYPE_MEMBER_EXPORT		
		pList.Add(LoadIcon(hMyInst,(LPCTSTR)IDI_PRIVMEMB));	// TYPE_MEMBER_PRIVATE		
		pList.Add(LoadIcon(hRes,(LPCTSTR)206));				// TYPE_FROM_ALS_CLASS
		pList.Add(LoadIcon(hRes,(LPCTSTR)213));				// TYPE_FROM_MD_CLASS		
		pList.Add(LoadIcon(hRes,(LPCTSTR)324));				// TYPE_HARD_PROC
		pList.Add(LoadIcon(hRes,(LPCTSTR)325));				// TYPE_HARD_MEMBER
		pList.Add(LoadIcon(hRes,(LPCTSTR)363));				// TYPE_FILE_FOLDER	
		CCPPView::m_HotKeys=LoadAccelerators(hMyInst,LPCTSTR(IDR_ACCELERATOR1));
		first=false;
	}
}

CCPPView::~CCPPView()
{
	KillTimer(WM_REFRESH_EDIT_LOCK);

	if(m_pRootData)
	{
		delete (CInfo*)m_pRootData;
		m_pRootData=NULL;
	}
	m_pView=NULL;
	CSyntax::Clear();
}

BEGIN_MESSAGE_MAP(CCPPView, CTreeView)
	ON_COMMAND(ID_EDIT_COPY,OnCopy)
	ON_COMMAND(ID_FILE_SAVE,OnSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_COMMAND(100,OnProp)
	//{{AFX_MSG_MAP(CCPPView)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDblclk)
	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(NM_RETURN, OnReturn)
	ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONDOWN()
	ON_NOTIFY_REFLECT(NM_SETFOCUS, OnSetfocus)
	ON_WM_KEYDOWN()
	ON_NOTIFY_REFLECT(TVN_BEGINDRAG, OnBegindrag)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCPPView drawing


CBodyTextView* CCPPView::FindTextView(CDocument* pDoc)
{
	if(!pDoc)
	{
		Log("   .");
		return NULL;
	}
	CView *pTextView=NULL;
	CString kind=pDoc->GetRuntimeClass()->m_lpszClassName;
	POSITION pos=pDoc->GetFirstViewPosition();
	pTextView=pDoc->GetNextView(pos);
	if(kind=="CWorkBookDoc")
	{
		((CWorkBookDoc*)pDoc)->SwitchToPage(1);
		CWnd* pChild=pTextView->GetWindow(GW_CHILD);
		if(pChild)
			pChild=pChild->GetNextWindow();
		if(pChild)
			pTextView=(CBodyTextView*)pChild->GetWindow(GW_CHILD);
	}
	if(strstr(pTextView->GetRuntimeClass()->m_lpszClassName,"CBodyTextView"))
		return (CBodyTextView*)pTextView;
	else
		return NULL;
}

void CCPPView::OnDraw(CDC* pDC)
{
}
/////////////////////////////////////////////////////////////////////////////
// CCPPView message handlers
void CCPPView::OnDblclk(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult=1;
	keybd_event(VK_RETURN,MapVirtualKey(0,VK_RETURN),0,0);
    keybd_event(VK_RETURN,MapVirtualKey(0,VK_RETURN),KEYEVENTF_KEYUP,0);
}

int CCPPView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if(CTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;
	if(!m_pDocument)
	{
		m_pDocument=(CDocument*)RUNTIME_CLASS(CCPPDoc)->CreateObject();
		m_pDocument->AddView(this);
	}
	GetTreeCtrl().SetImageList(&m_ImageList,TVSIL_NORMAL);
	FillList();

//AfxMessageBox("1");
//	CSyntax::SetHook();
//AfxMessageBox("2");

	return 0;
}

BOOL CCPPView::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style|=TVS_HASLINES|TVS_LINESATROOT|TVS_HASBUTTONS;
	return CTreeView::PreCreateWindow(cs);
}

void CCPPView::FillList()
{
	CInfo *info=new CInfoWrcSpace;
	m_pRootData=info;
	info->InsertInTree(TVI_ROOT);
	Sort(TVI_ROOT);
	UpdateModified();
}

void CCPPView::OnReturn(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 1;
	CInfo* pInfo=CInfo::GetData(GetTreeCtrl().GetSelectedItem());
	if(pInfo)
		pInfo->OnSelect();
}

void CCPPView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	HTREEITEM item=GetTreeCtrl().GetSelectedItem();
	if (!this)
		return;
	CInfo* pInfo=CInfo::GetData(item);
	if(!pInfo)
		return;
	if(!m_click.x && !m_click.y)
	{
		CRect rc;
		if(GetTreeCtrl().GetItemRect(item,rc,TRUE))
		{
			if(rc.bottom>0 && rc.left>0)
				m_click.x=rc.left,m_click.y=rc.bottom;
		}
	}
	ClientToScreen(&m_click);
	pInfo->ShowContextMenu(m_click);
	m_click=CPoint(0,0);
}
void CCPPView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	UINT fl;
	HTREEITEM item=GetTreeCtrl().HitTest(point,&fl);
	if(item)
	{
		m_click=point;
		GetTreeCtrl().SelectItem(item);
	}
}

int CALLBACK CompareGroup(LPARAM lParam1, LPARAM lParam2, 
		LPARAM lParamSort)
{
	CInfo* pItem1=(CInfo*)lParam1;
	CInfo* pItem2=(CInfo*)lParam2;
	if(pItem1->m_IconCollapse==pItem2->m_IconCollapse)
		return pItem1->m_DisplayName.CollateNoCase(pItem2->m_DisplayName);
	return pItem1->m_IconCollapse-pItem2->m_IconCollapse;
}
int CALLBACK Compare(LPARAM lParam1, LPARAM lParam2, 
		LPARAM lParamSort)
{
	CInfo* pItem1=(CInfo*)lParam1;
	CInfo* pItem2=(CInfo*)lParam2;
	if(pItem1->m_IconCollapse>2 && pItem1->m_IconCollapse<8)
		return pItem1->m_DisplayName.CollateNoCase(pItem2->m_DisplayName);
	if(pItem1->m_IconCollapse==pItem2->m_IconCollapse)
		return pItem1->m_DisplayName.CollateNoCase(pItem2->m_DisplayName);
	return pItem1->m_IconCollapse-pItem2->m_IconCollapse;
}

void CCPPView::Sort(HTREEITEM hParent)
{
	HTREEITEM hItem=GetTreeCtrl().GetChildItem(hParent);
	while(hItem)
	{
		Sort(hItem);
		hItem=GetTreeCtrl().GetNextItem(hItem,TVGN_NEXT);
	}
	TVSORTCB sort;
	sort.hParent=hParent;
	sort.lParam=0;
	sort.lpfnCompare=CInfo::m_IsSort?CompareGroup:Compare;
	GetTreeCtrl().SortChildrenCB(&sort);
}

void CCPPView::Refresh()
{
    GetTreeCtrl().DeleteAllItems();
	if(m_pRootData)
		delete (CInfo*)m_pRootData;
	if(CMetaDataOfClasses::m_oneMetadata)
		delete CMetaDataOfClasses::m_oneMetadata;
  CMetaDataOfClasses::m_oneMetadata = new CMetaDataOfClasses;
	((CCPPDoc*)GetDocument())->m_Meta = CMetaDataOfClasses::m_oneMetadata;

	CClassInfo::RemoveAllFileNameInMap(); //CClassInfo::m_ClassFileNameMap.RemoveAll();

	FillList();
}

void CCPPView::OnCopy()
{
	CInfo* pInfo=CInfo::GetData(GetTreeCtrl().GetSelectedItem());
	if(!pInfo)
		return;
	CString txt=pInfo->GetCopyText();
	HGLOBAL hglbCopy = GlobalAlloc(GMEM_DDESHARE,txt.GetLength()+1);
	if(!hglbCopy)
		return;
	LPSTR lpStr=(LPSTR)GlobalLock(hglbCopy);
	if(!lpStr)
		return;
	memcpy(lpStr,(LPCTSTR)txt,txt.GetLength()+1);
	GlobalUnlock(hglbCopy);
	OpenClipboard();
	EmptyClipboard();
	SetClipboardData(CF_TEXT,hglbCopy);
	CloseClipboard();
}

void CCPPView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	CTreeView::OnActivateView(bActivate, pActivateView, pDeactiveView);
	if(!bActivate)
		return;
	MiniRefresh();

	SetTimer(WM_REFRESH_EDIT_LOCK,1000,0);
}

BOOL CCPPView::PreTranslateMessage(MSG* pMsg) 
{
	if(TranslateAccelerator(m_hWnd,m_HotKeys,pMsg))
		return TRUE;
	return CTreeView::PreTranslateMessage(pMsg);
}

void CCPPView::SortOneNode(HTREEITEM item)
{
	TVSORTCB sort;
	sort.hParent=item;
	sort.lParam=0;
	sort.lpfnCompare=CInfo::m_IsSort?CompareGroup:Compare;
	GetTreeCtrl().SortChildrenCB(&sort);
}

void CCPPView::OnProp()
{
	CInfo* pInfo=CInfo::GetData(GetTreeCtrl().GetSelectedItem());
	if(pInfo)
		pInfo->ShowProperties();
}

void CCPPView::UpdateClass(CDocument *pDoc)
{
	CString cl;
	CClassInfo* pClassInfo = NULL;
	cl=pDoc->GetTitle();
	if(CClassInfo::m_ClassInfoMap.Lookup(cl,(void*&)pClassInfo))
	{
		pClassInfo->PrepareKeys();
		POSITION pos=pClassInfo->GetNodesList().GetHeadPosition();
		while(pos)
		{
			HTREEITEM item=(HTREEITEM)pClassInfo->GetNodesList().GetNext(pos);
			pClassInfo->InsertKeys(item);
			SortOneNode(item);
		}
		pClassInfo->ClearRemoved();
	}
}

void CCPPView::UpdateModified()
{
	bool mod;
	bool AllMod=false;
	CString cl;
	CDocument* pDoc;
	CClassInfo* pClassInfo = NULL;
	for(POSITION pos=CClassInfo::m_ClassInfoMap.GetStartPosition();pos;)
	{
		mod=false;
		CClassInfo::m_ClassInfoMap.GetNextAssoc(pos,cl,(void*&)pClassInfo);
		if(CMyTextDoc::m_Hooked.Lookup(pClassInfo->GetImplementPath(),(CObject*&)pDoc))
			mod=pDoc->IsModified()==TRUE;
		if(mod)
			AllMod=true;
		POSITION pos1=pClassInfo->GetNodesList().GetHeadPosition();
		while(pos1)
		{
			HTREEITEM item=(HTREEITEM)pClassInfo->GetNodesList().GetNext(pos1);
			GetTreeCtrl().SetItemText(item,pClassInfo->m_DisplayName+pClassInfo->m_Status+(mod?" *":""));
		}
	}
	CTreeCtrl& ctrl=GetTreeCtrl();
	HTREEITEM first=ctrl.GetChildItem(TVI_ROOT),item=ctrl.GetChildItem(first);
	while(item)
	{
		CDefFileInfo* pInfo=(CDefFileInfo*)CInfo::GetData(item);
		if(pInfo)
		{
			mod=false;
			if(CMyTextDoc::m_Hooked.Lookup(pInfo->m_path,(CObject*&)pDoc))
				mod=pDoc->IsModified()==TRUE;
			if(mod)
				AllMod=true;
			ctrl.SetItemText(item,pInfo->m_DisplayName+pInfo->m_Status+(mod?" *":""));
		}
		item=ctrl.GetNextItem(item,TVGN_NEXT);
	}
	CInfo* pRoot=(CInfo*)m_pRootData;
	if(pRoot)
		ctrl.SetItemText(first,pRoot->m_DisplayName+pRoot->m_Status+(AllMod?" *":""));
}

void CCPPView::OnUpdateFileSave(CCmdUI *pcm)
{
	CInfo* pInfo=CInfo::GetData(GetTreeCtrl().GetSelectedItem());
	if(!pInfo)
	{
		pcm->Enable(FALSE);
		return;
	}
	if(pInfo->m_IconCollapse>TYPE_CLASS_FOLDER)
	{
		pcm->Enable(FALSE);
		return;
	}
	CString txt=GetTreeCtrl().GetItemText(CInfo::m_CurItem);
	pcm->Enable(txt.ReverseFind('*')==txt.GetLength()-1);
}

void CCPPView::OnSave()
{
	CInfo* pInfo=CInfo::GetData(GetTreeCtrl().GetSelectedItem());
	if(!pInfo)
		return;
	if(pInfo->m_IconCollapse>TYPE_CLASS_FOLDER)
		return;
	CDocument* pDoc;
	if(pInfo->m_IconCollapse==TYPE_CLASS_FOLDER)
	{
		if(CMyTextDoc::m_Hooked.Lookup(((CClassInfo*)pInfo)->GetImplementPath(),(CObject*&)pDoc))
			pDoc->OnCmdMsg(ID_FILE_SAVE,(WM_COMMAND<<16)|CN_COMMAND,NULL,NULL);
	}
	else if(pInfo->m_IconCollapse==TYPE_DEF_FILE_FOLDER)
	{
		if(CMyTextDoc::m_Hooked.Lookup(((CDefFileInfo*)pInfo)->m_path,(CObject*&)pDoc))
			pDoc->OnCmdMsg(ID_FILE_SAVE,(WM_COMMAND<<16)|CN_COMMAND,NULL,NULL);
	}
	else
	{
		CString path;
		for(POSITION pos=CMyTextDoc::m_Hooked.GetStartPosition();pos;)
		{
			CMyTextDoc::m_Hooked.GetNextAssoc(pos,path,(CObject*&)pDoc);
			pDoc->OnCmdMsg(ID_FILE_SAVE,(WM_COMMAND<<16)|CN_COMMAND,NULL,NULL);
		}
	}
	CCPPView::m_pView->UpdateModified();
}

void CCPPView::OnSetfocus(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 1;
	MiniRefresh();

	// ..
	CMyLock::SetViewCtrl(this);
	CMyLock::UpdateTreeCtrl();

}

void CCPPView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar==VK_ESCAPE)
	{
		SECMDIFrameWnd* pFrame=(SECMDIFrameWnd*)AfxGetMainWnd();
		CMDIChildWnd* pChild=pFrame->MDIGetActive();
		if(pChild && pChild->IsWindowVisible())
		{
			pChild->ActivateFrame();
			CView* pView=pChild->GetActiveView();
			if(pView)
			{
				pView->SetFocus();
				return;
			}
		}
	}
	// ..
	if(nChar==VK_F5)
	{
		CMyLock::UpdateTreeCtrl();
		return;
	}

	CTreeView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CCPPView::MiniRefresh()
{
	CString cl;
	CDocument* pDoc;
	CClassInfo* pClassInfo = NULL;
	MAP_S_I changed;
	for(POSITION pos=CMyTextDoc::m_Hooked.GetStartPosition();pos;)
	{
		CMyTextDoc::m_Hooked.GetNextAssoc(pos,cl,(CObject*&)pDoc);
		cl=pDoc->GetTitle();
		if(CClassInfo::m_ClassInfoMap.Lookup(cl,(void*&)pClassInfo))
		{
			changed[cl]=pClassInfo;
			pClassInfo->PrepareKeys();
		}
	}
	for(SI_IT it=changed.begin();it!=changed.end();it++)
	{
		pClassInfo=(CClassInfo*)it->second;
		POSITION pos=pClassInfo->GetNodesList().GetHeadPosition();
		while(pos)
		{
			HTREEITEM item=(HTREEITEM)pClassInfo->GetNodesList().GetNext(pos);
			pClassInfo->InsertKeys(item);
			SortOneNode(item);
		}
		pClassInfo->ClearRemoved();
	}
	UpdateModified();
}

void CCPPView::OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	CTreeCtrl& pTreeCtl = GetTreeCtrl();
	HTREEITEM nItem = pTreeCtl.GetSelectedItem();
	if ((pNMTreeView) != NULL){ 
		if (pTreeCtl.GetItem(&(pNMTreeView->itemNew))){ 
			CString strItem;
			strItem = pTreeCtl.GetItemText(pNMTreeView->itemNew.hItem);
			HGLOBAL hGlobal = GlobalAlloc(GMEM_SHARE,
						  strItem.GetLength() + 1);
			LPSTR   pszGlobal = (LPSTR)GlobalLock(hGlobal);
			ASSERT(pszGlobal);
			lstrcpy(pszGlobal, strItem);
			GlobalUnlock(hGlobal);
			COleDataSource srcItem;

			srcItem.CacheGlobalData(CF_TEXT, hGlobal);

			srcItem.DoDragDrop(DROPEFFECT_COPY|DROPEFFECT_MOVE);
		} 
	}		
	*pResult = 0;
}

void CCPPView::OnTimer(UINT nIDEvent) 
{
	if(WM_REFRESH_EDIT_LOCK==nIDEvent)
	{
		CMyLock::CheckForEditLck();
		return;
	}

	
	CTreeView::OnTimer(nIDEvent);
}
