// ClassInfo.cpp: implementation of the CClassInfo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "vis1cpp.h"
#include "ClassInfo.h"
#include ".\1cpp\MetaDataOfClasses.h"
#include "declprocinfo.h"
#include "mytextdoc.h"
#include "moduleparser.h"
#include "deffileinfo.h"

#include "procinfo.h"
#include "procexinfo.h"
#include "valinfo.h"
#include "valexinfo.h"
#include "classprop.h"
#include "syntax.h"
#include "MyLock.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CMapStringToPtr CClassInfo::m_ClassInfoMap;

//CMapStringToPtr CClassInfo::m_ClassFileNameMap;
CIStringMap<CClassInfo*, CClassInfo*> CClassInfo::m_ClassFileNameMap;

CClassInfo::CClassInfo(CString name):CInfo(name,TYPE_CLASS_FOLDER)
{
	m_ImplementPath=CMetaDataOfClasses::m_oneMetadata->m_ClassBindFile[m_DisplayName];
	if (!this)
		RuntimeError("ClassInfo* this == NULL :(");
	
	m_ClassFileNameMap[m_ImplementPath] = this; // artbear

	m_DefinePath=CMetaDataOfClasses::m_oneMetadata->m_FullFileNameOfDescrFile[m_DisplayName];
	CMapStringToOb* pMetodsMap=(CMapStringToOb*)CMetaDataOfClasses::m_oneMetadata->m_TypeOfClassMeth[m_DisplayName];
	if(pMetodsMap)
	{
		CMetaDataOfClasses::ARR_TYPE_NAME* pType;
		CString proc;
		for(POSITION pos=pMetodsMap->GetStartPosition();pos;)
		{
			pMetodsMap->GetNextAssoc(pos,proc,(CObject*&)pType);
			m_declProc[proc]=new CDeclProcInfo(proc,pType);
		}
	}
	m_mod.m_path=m_ImplementPath;
	m_mod.m_path.MakeLower();
	PrepareKeys();
}

CClassInfo::~CClassInfo()
{
	ClearKeys();
}

HTREEITEM CClassInfo::InsertInTree(HTREEITEM parent)
{
	HTREEITEM item=CInfo::InsertInTree(parent);
	m_nodes.AddTail((void*)item);

	m_mod.ParseClassModule(m_DisplayName);

	CString proc;
	for(SI_IT it=m_declProc.begin();it!=m_declProc.end();it++)
		it->second->InsertInTree(item);

	// add base classes
	CMapStringToOb& map=CMetaDataOfClasses::m_oneMetadata->m_ClassesHierarchyMap;
	CClassInfo* pParent=(CClassInfo*)GetData(item);
	CStringList* list;
// artbear
//Msg("pParent->m_DisplayName %s", pParent->m_DisplayName);
//CString m_ImplementPath=CMetaDataOfClasses::m_oneMetadata->m_ClassBindFile[m_DisplayName];
//Msg("pParent->m_DisplayName %s, m_ImplementPath %s", pParent->m_DisplayName, m_ImplementPath);
//m_DefinePath=CMetaDataOfClasses::m_oneMetadata->m_FullFileNameOfDescrFile[m_DisplayName];
//Msg("m_DefinePath %s", m_DefinePath);

	if(map.Lookup(pParent->m_DisplayName,(CObject*&)list))
	{
		if (list)
			for(POSITION pos=list->GetHeadPosition();pos;)
			{
 // artbear
				CClassInfo* pClass=CClassInfo::FindClassInfo(list->GetNext(pos));
//	CString str = list->GetNext(pos);
//LogErr("  list->GetNext(pos) = %s", str);
//				CClassInfo* pClass=CClassInfo::FindClassInfo(str);

				pClass->InsertInTree(item);
			}
	}

	InsertKeys(item);
	return item;
}

void CClassInfo::OnSelect()
{
/*
	//CMDSubDoc
	CWinApp* pApp=AfxGetApp();
	CMyDocTemp* pT;
	CAssistantDoc* pDoc=NULL;
	for(POSITION pos=pApp->GetFirstDocTemplatePosition();pos;)
	{
		pT=(CMyDocTemp*)pApp->GetNextDocTemplate(pos);
		if(CString("CAssistantDoc")==pT->GetDocClass()->m_lpszClassName)
		{
			POSITION p=pT->GetFirstDocPosition();
			if(p)
			{
				pDoc=(CAssistantDoc*)pT->GetNextDoc(p);
				break;
			}
		}
	}
	CAssistantView *pView=(CAssistantView*)pDoc->GetView();
	HTREEITEM item=pDoc->GetPermanentRoot();
	CItemList List;
	pDoc->GetItemData(item,&List);
	CString s1,s2;
	pDoc->GetPermStrins(&List,s1,s2);
	return;
	UINT id=CTemplate7::GetDocumentTemplateID(13);
	CTemplate7* pTemp=CTemplate7::FromID(id);
	if(pTemp)
	{
		CMyDocTemp* pT=(CMyDocTemp*)pTemp;
		CString rtc=PrintRTC(pT->GetDocClass());
		pTemp->OpenDocumentFileEx("X:\\Tornado\\1cv7srct.st",0,TRUE);
	}
	return;


	HINSTANCE h7=GetModuleHandle("seven.dll");
	static const char* names[]={
		"?classCAccContextDef@CAccContextDef@@2UCRuntimeClass@@B",
		"?classCAccFormContextDef@CAccFormContextDef@@2UCRuntimeClass@@B",
		"?classCAccListFormContextDef@CAccListFormContextDef@@2UCRuntimeClass@@B",
		"?classCAccountContextDef@CAccountContextDef@@2UCRuntimeClass@@B",
		"?classCCJContextDef@CCJContextDef@@2UCRuntimeClass@@B",
		"?classCCJFormContextDef@CCJFormContextDef@@2UCRuntimeClass@@B",
	//	"?classCCJPeriodContext@CCJPeriodContext@@2UCRuntimeClass@@B",
	//	"?classCCJRecordContext@CCJRecordContext@@2UCRuntimeClass@@B",
		"?classCCalcContextDef@CCalcContextDef@@2UCRuntimeClass@@B",
		"?classCDocContextDef@CDocContextDef@@2UCRuntimeClass@@B",
		"?classCDocEnvironContextDef@CDocEnvironContextDef@@2UCRuntimeClass@@B",
		"?classCDocFormContextDef@CDocFormContextDef@@2UCRuntimeClass@@B",
		"?classCFormContextDef@CFormContextDef@@2UCRuntimeClass@@B",
		"?classCGeneralContextDef@CGeneralContextDef@@2UCRuntimeClass@@B",
		"?classCJournalContextDef@CJournalContextDef@@2UCRuntimeClass@@B",
		"?classCOperContextDef@COperContextDef@@2UCRuntimeClass@@B",
		"?classCOperFormContextDef@COperFormContextDef@@2UCRuntimeClass@@B",
		"?classCOperJournalContextDef@COperJournalContextDef@@2UCRuntimeClass@@B",
		"?classCProvJournalContextDef@CProvJournalContextDef@@2UCRuntimeClass@@B",
		"?classCRepFormContextDef@CRepFormContextDef@@2UCRuntimeClass@@B",
		"?classCSubcContextDef@CSubcContextDef@@2UCRuntimeClass@@B",
		"?classCSubcFormContextDef@CSubcFormContextDef@@2UCRuntimeClass@@B",
		"?classCSubcItemFormContextDef@CSubcItemFormContextDef@@2UCRuntimeClass@@B",
		"?classCTradeContextDef@CTradeContextDef@@2UCRuntimeClass@@B"};
	//	"?classCXBaseContext@CXBaseContext@@2UCRuntimeClass@@B",
	//	"?classCXBaseKeyContext@CXBaseKeyContext@@2UCRuntimeClass@@B"};

	CRuntimeClass *pC;
	for(int r=0;r<22;r++)
	{
		pC=(CRuntimeClass*)GetProcAddress(h7,names[r]);
		CString txt=PrintRTC(pC);
		Log(txt);
		CBLContext* pDef=(CBLContext*)pC->CreateObject();
		if(!pDef)
		{
			Log("No create");
			continue;
		}
		int nMet=pDef->GetNMethods();
		for(int i=0;i<nMet;i++)
		{
			txt=pDef->GetMethodName(i,0);
			txt=txt+"  "+pDef->GetMethodName(i,1);
			Log(txt);
		}
	}
	return;
	//*/


	if(m_ImplementPath.IsEmpty())
		return;
	OpenClass();
	//if(m_DefinePath.IsEmpty())
	//	return;
	//OpenDef();
}

int CClassInfo::GetContextMenu(CStringList &lst,CPtrList &idflags)
{
	UINT flag;
	lst.AddTail(" ");
	flag=m_DefinePath.IsEmpty()?MF_GRAYED<<16:0;

	idflags.AddTail((void*)(1|flag));

	lst.AddTail(" &");
	flag=m_ImplementPath.IsEmpty()?MF_GRAYED<<16:0;
	idflags.AddTail((void*)(2|flag));
	CDocument* pDoc;
	flag=MF_GRAYED<<16;
	if(CMyTextDoc::m_Hooked.Lookup(m_ImplementPath,(CObject*&)pDoc))
		flag=pDoc->IsModified()?0:MF_GRAYED<<16;
	lst.AddTail("\tCtrl+S");
	idflags.AddTail((void*)(3|flag));

	lst.AddTail("");
	idflags.AddTail((void*)0);

	flag=m_ImplementPath.IsEmpty()?MF_GRAYED<<16:0;
	lst.AddTail("-  &");
	idflags.AddTail((void*)(4|flag));

	lst.AddTail("&-  ");
	idflags.AddTail((void*)(5|flag));

	/*	lst.AddTail("");
	idflags.AddTail((void*)0);

	lst.AddTail(" ...");
	idflags.AddTail((void*)3);

	lst.AddTail(" ...");
	idflags.AddTail((void*)4);
	lst.AddTail("");
	idflags.AddTail((void*)0);

	lst.AddTail("");
	idflags.AddTail((void*)4);
	*/


	// .. 07.07.07
	CMyLock::GetContextMenu(m_ImplementPath,lst,idflags);



	return 0;
}
void CClassInfo::OnContextMenu(UINT cmd)
{
	if(cmd==1)
		OpenDef();
	else if(cmd==2)
		OpenClass();
	else if(cmd==3)
		CCPPView::m_pView->OnSave();
	else if(cmd==4 || cmd==5)
	{
		if(m_ImplementPath.IsEmpty())
			return;
		CSyntax::CompileOne(this,cmd==4?true:false, true);
	}
	else
	{
		// .. 07.07.07
		if(CMyLock::OnContextMenu(m_ImplementPath,cmd))
			return;
	}
}

CDocument* CClassInfo::OpenClass()
{
//LogErr("m_ImplementPath %s", m_ImplementPath);

	if(m_ImplementPath.IsEmpty())
	{
			Log("     ",mmNone,true);
			return NULL;
	}
	CDocument* pDoc = NULL;
  {
		CString tPath = pSvc->IBDir()+m_ImplementPath;
		//    ?   ,  
		//    ,     
		// ,           
		DWORD tRes = GetFileAttributes((LPCTSTR)tPath);
		if (tRes != 0xFFFFFFFF){
				pDoc=pSvc->OpenFile( tPath );
		}
		if (!pDoc){
				pDoc=pSvc->OpenFile(m_ImplementPath);
		}
  }
	if(!pDoc)
	{
		CString strTemp = m_ImplementPath;
		strTemp.MakeLower();
		int npos = strTemp.Find("@md");
		CString nameRep = strTemp.Left(npos);

		CMetaDataCont *pMD = GetMetaData();
		if(pMD)
		{
			CMetaDataObj* pObj=(CMetaDataObj*)pMD->GetCalcVarDef(nameRep);
			if(pObj)
			{
				long id=pObj->GetID();
				CTypedCont* pCont=NULL;
				CString text;
				CConfigCont::IDToPath(id,"CalcVar",text,&pCont,FALSE);

				if(pCont)
				{
					//try{
						pDoc = (CDocument*)pCont->GetWorkBook();
						pCont->ShowDocument(id);  //  
					/*}
					catch(...)
					{}*/

				}
			}
		}
		if(!pDoc)
		{
			Log("    %s",mmBlackErr,false,(LPCTSTR)m_DisplayName);
			return NULL;
		}
	}
	if(!strcmp("CWorkBookDoc",pDoc->GetRuntimeClass()->m_lpszClassName))
		((CWorkBookDoc*)pDoc)->SwitchToPage(1);

//AfxMessageBox(pDoc->GetRuntimeClass()->m_lpszClassName);
	CMyTextDoc::HookDoc(pDoc,m_DisplayName);
/*// artbeaR
	CGetDoc7* pDoc7 = (CGetDoc7*)pDoc;
	//CBLModule7* pMod = 
Msg("pDoc7->m_ContName %s", pDoc7->m_ContName);
Msg("pDoc7->m_pString %s", pDoc7->m_pString);
Msg("pDoc7->m_String1 %s", pDoc7->m_String1);
Msg("pDoc7->m_String2 %s", pDoc7->m_String2);
Msg("pDoc7->m_pBLModule %d", pDoc7->m_pBLModule);
*/

	return pDoc;
}

void CClassInfo::OpenDef()
{
	CModuleParser mod;
	int line;
	CBodyTextView* pEditor=mod.FindDef(CDefFileInfo::OpenDef(m_DefinePath),m_DisplayName,line);
	if(pEditor)
	{
		if(line>-1)
		{
			pEditor->MoveCaret(CPoint(0,line+40),CPoint(0,line+40),1);
			pEditor->MoveCaret(CPoint(0,line),CPoint(((CBodyTextDoc*)pEditor->GetDocument())->GetLineLength(line)-2,line),1);
		}
		else
			Log(m_DisplayName+" :     "+m_DefinePath);
	}
}
CClassInfo* CClassInfo::FindClassInfo(const CString& ClassName)
{
	CClassInfo* pInfo = NULL;
	if(!m_ClassInfoMap.Lookup(ClassName,(void*&)pInfo))
	{
		pInfo=new CClassInfo(ClassName);
//Msg("ClassName %s", ClassName);
		m_ClassInfoMap[ClassName]=pInfo;
	}
	return pInfo;
}

void CClassInfo::OpenKeys(CString &name)
{
	CDocument* pDoc=OpenClass();
	CBodyTextView *pEditor=CCPPView::FindTextView(pDoc);
	if(!pEditor)
	{
		Log("    ");
		return;
	}

	m_mod.ParseClassModule(m_DisplayName);

	SD_IT it=m_mod.m_keys.find(name);
	if(it!=m_mod.m_keys.end())
	{
		DWORD line = 0x3FFFFFFF & it->second;
		line += m_mod.getOffsetLines();

		pEditor->GetParentFrame()->ActivateFrame();
		pEditor->SetFocus();
		pEditor->MoveCaret(CPoint(0,line+40),CPoint(0,line+40),10);
		pEditor->MoveCaret(CPoint(0,line),CPoint(((CBodyTextDoc*)pEditor->GetDocument())->GetLineLength(line)-2,line),1);
	}
	else
	{
		CString err;
		err.Format("\"%s\"     .",(LPCTSTR)name);
		AfxMessageBox(err);
	}
}

void CClassInfo::ClearKeys()
{
	for(SI_IT it=m_keys.begin();it!=m_keys.end();it++)
		delete it->second;
	m_keys.clear();
	for(it=m_declProc.begin();it!=m_declProc.end();it++)
		delete it->second;
	m_declProc.clear();
	ClearRemoved();
}

void CClassInfo::PrepareKeys()
{
	static const DWORD icon[]={TYPE_MODULE_PROC_PRIVATE,TYPE_MEMBER_PRIVATE,TYPE_MODULE_PROC_EXPORT,TYPE_MEMBER_EXPORT};

	m_mod.ParseClassModule(m_DisplayName);

	CInfo *pNew;
	CString proc;
	SI_IT itkeys;
	SI_IT itdecl;
	SD_IT itproc;
	for(itkeys=m_keys.begin();itkeys!=m_keys.end();)
	{
		itproc=m_mod.m_keys.find(itkeys->first);
		bool found=true;
		if(itproc==m_mod.m_keys.end())
			found=false;
		else if(itkeys->second->m_IconCollapse!=icon[itproc->second>>30])
			found=false;
		if(!found)
		{
			m_removedKeys[itkeys->first]=itkeys->second;
			itkeys=m_keys.erase(itkeys);
			continue;
		}
		itkeys++;
	}
	for(itproc=m_mod.m_keys.begin();itproc!=m_mod.m_keys.end();itproc++)
	{
		proc=itproc->first;
		itdecl=m_declProc.find(proc);
		if(itdecl!=m_declProc.end())
				continue;
		itkeys=m_keys.find(proc);
		if(itkeys!=m_keys.end())
			continue;
		DWORD type=itproc->second>>30;
		switch(type){
		case 0:
			pNew=new CProcInfo(proc);
			break;
		case 2:
			pNew=new CProcExInfo(proc);
			break;
		case 1:
			pNew=new CValInfo(proc);
			break;
		case 3:
			pNew=new CValExInfo(proc);
		}
		m_keys[proc]=pNew;
	}
}

void CClassInfo::InsertKeys(HTREEITEM item)
{
	CTreeCtrl& ctrl=CCPPView::m_pView->GetTreeCtrl();
	HTREEITEM child=ctrl.GetNextItem(item,TVGN_CHILD);
	CInfo* pInfo;
	MAP_S_I exist;
	SI_IT it,ex;
	while(child)
	{
		pInfo=CInfo::GetData(child);
		if(pInfo->m_IconCollapse>TYPE_DECLARED_PROC && pInfo->m_IconCollapse<TYPE_FROM_ALS_CLASS)
		{
			it=m_removedKeys.find(pInfo->m_DisplayName);
			if(it!=m_removedKeys.end())
			{
				HTREEITEM del=child;
				child=ctrl.GetNextItem(child,TVGN_NEXT);
				ctrl.DeleteItem(del);
				continue;
			}
			else
			{
				//Log(CString("Exist ")+pInfo->m_DisplayName);
				exist[pInfo->m_DisplayName]=pInfo;
			}
		}
		child=ctrl.GetNextItem(child,TVGN_NEXT);
	}
	for(it=m_keys.begin();it!=m_keys.end();it++)
	{
		ex=exist.find(it->first);
		if(ex==exist.end())
			it->second->InsertInTree(item);
	}
}

void CClassInfo::ClearRemoved()
{
	for(SI_IT it=m_removedKeys.begin();it!=m_removedKeys.end();it++)
		delete it->second;
	m_removedKeys.clear();
}
void CClassInfo::GetProp(CPtrArray& pArr)
{
	CClassProp* pProp=new CClassProp;
	pProp->m_def=m_DefinePath;
	pProp->m_mod=m_ImplementPath;
	pArr.Add(pProp);
}
