// ClassInfo.h: interface for the CClassInfo class.

#if !defined(AFX_CLASSINFO_H__B17668A4_C46F_46F2_9ECF_600073C316E1__INCLUDED_)

#define AFX_CLASSINFO_H__B17668A4_C46F_46F2_9ECF_600073C316E1__INCLUDED_



#if _MSC_VER > 1000

#pragma once

#endif // _MSC_VER > 1000



#include "Info.h"

#include "cppview.h"

#include "moduleparser.h"



typedef map<CString,CInfo*,CompNoCase> MAP_S_I;

typedef MAP_S_I::iterator SI_IT;



class CClassInfo : public CInfo  

{

public:

	

	CClassInfo(CString name);

	virtual ~CClassInfo();



	void ClearRemoved();

	void InsertKeys(HTREEITEM item);

	void PrepareKeys();

	void ClearKeys();

	void OpenKeys(CString& name);



	CDocument* OpenClass();

	HTREEITEM InsertInTree(HTREEITEM parent);

private:

	void GetProp(CPtrArray& pArr);



	void OpenDef();

	void OnSelect();

	

	int  GetContextMenu(CStringList& list,CPtrList& idflags);

	void OnContextMenu(UINT cmd);



private:

	CString m_ImplementPath;

	CString m_DefinePath;

	MAP_S_I m_keys;

	MAP_S_I m_removedKeys;

	MAP_S_I m_declProc;

	CModuleParser m_mod;

	CPtrList m_nodes;



public:

	const CString& GetImplementPath() const { return m_ImplementPath; }

	const CPtrList& GetNodesList() const { return m_nodes; }



	static CMapStringToPtr m_ClassInfoMap;

	static CClassInfo* FindClassInfo(const CString& ClassName);



private:



	//static CMapStringToPtr m_ClassFileNameMap;

	static CIStringMap<CClassInfo*, CClassInfo*> m_ClassFileNameMap;

public:	

	static void RemoveAllFileNameInMap(void)

	{

		m_ClassFileNameMap.RemoveAll();

	}

	static int LookupByFileName(const CString& strDocFullPath, CClassInfo*& pInfo)

	{

		return CClassInfo::m_ClassFileNameMap.Lookup(strDocFullPath, pInfo);

	}

private:

	//  , ,  

	//  , ,      

	//        

	//	(,     )

	CString m_SourceText;

public:	

	void SetSourceText(const CString& txt)

	{

		m_SourceText = txt;

	}

	

	CString GetSourceText(void)

	{

		if (!m_SourceText.IsEmpty())

			return m_SourceText;



		return m_mod.GetSrc(true);

	}

	

};



#endif // !defined(AFX_CLASSINFO_H__B17668A4_C46F_46F2_9ECF_600073C316E1__INCLUDED_)

