// DefFileInfo.cpp: implementation of the CDefFileInfo class.
//
//////////////////////////////////////////////////////////////////////
#include "rootprop.h"
#include "stdafx.h"
#include "vis1cpp.h"
#include "DefFileInfo.h"
#include "classinfo.h"
#include "InfoWrcSpace.h"
#include "mytextdoc.h"
#include "rootprop.h"
#include "MyLock.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDefFileInfo::CDefFileInfo(const CString& path):CInfo("",TYPE_DEF_FILE_FOLDER)
{
	m_path=path;//.Left(path.ReverseFind('\\'));
	m_DisplayName=MakeDisplayName(path);
}

CDefFileInfo::~CDefFileInfo()
{
}

HTREEITEM CDefFileInfo::InsertInTree(HTREEITEM parent)
{
	HTREEITEM item=CInfo::InsertInTree(parent);
	CStringList* pList=(CStringList*)CInfoWrcSpace::m_mapDef[m_path];
	for(POSITION pos=pList->GetHeadPosition();pos;)
	{
		CClassInfo* pInfo=CClassInfo::FindClassInfo(pList->GetNext(pos));
		pInfo->InsertInTree(item);
	}
	return item;
}

void CDefFileInfo::OnSelect()
{
	OpenDef(m_path);
}

CString CDefFileInfo::MakeDisplayName(const CString &path)
{
	CString ib=pSvc->IBDir(),p=path,key;
	ib.MakeLower();p.MakeLower();
	if(!p.Find(ib))
		return path.Mid(ib.GetLength());
	
	CMapStringToString& map=CMetaDataOfClasses::m_oneMetadata->m_AliasOfPaths;
	for(POSITION pos=map.GetStartPosition();pos;)
	{
		map.GetNextAssoc(pos,key,ib);
		ib.MakeLower();
		if(!p.Find(ib))
			return CString("#")+key+" - "+path.Mid(ib.GetLength()+1);
	}
	return path;
}

CDocument* CDefFileInfo::OpenDef(LPCTSTR path)
{
	bool err=false;
	if(!path)
		err=true;
	else if(!*path)
		err=true;
	if(err)
	{
		AfxMessageBox("   .");
		return NULL;
	}
// artbear
//	CDocument* pDoc=pSvc->OpenFile(path);
	CDocument* pDoc;
	{
	CString strTempPath = path;
	strTempPath.MakeLower();

	if ("defcls@md" == strTempPath)
	{
		CString nameRep = "defcls";
		CMetaDataCont *pMD = GetMetaData();  
		if(pMD)
		{
			CMetaDataObj* pObj=(CMetaDataObj*)pMD->GetCalcVarDef(nameRep);
			if(pObj)
			{
				long id=pObj->GetID();
				CTypedCont* pCont=NULL;
				CString text;
				CConfigCont::IDToPath(id,"CalcVar",text,&pCont,FALSE);

				if(pCont)
				{
					//try{
						pDoc = (CDocument*)pCont->GetWorkBook();        
						pCont->ShowDocument(id);  //  
					/*}
					catch(...)
					{}*/
					
				}
			}
		}
	}
	else
		pDoc=pSvc->OpenFile(path);
	}
// end
	if(pDoc)
	{
		if(!strcmp("CWorkBookDoc",pDoc->GetRuntimeClass()->m_lpszClassName))
			((CWorkBookDoc*)pDoc)->SwitchToPage(1);
		CMyTextDoc::HookDoc(pDoc,path);
	}
	return pDoc;
}
void CDefFileInfo::GetProp(CPtrArray& pArr)
{
	CRootProp *pProp=new CRootProp;
	pProp->m_path=m_path;
	pArr.Add(pProp);
}
int  CDefFileInfo::GetContextMenu(CStringList& lst,CPtrList& idflags)
{
	lst.AddTail("");
	idflags.AddTail((void*)1);
	UINT flag=MF_GRAYED;
	CDocument* pDoc;
	if(CMyTextDoc::m_Hooked.Lookup(m_path,(CObject*&)pDoc))
		flag=pDoc->IsModified()?0:MF_GRAYED;
	lst.AddTail("\tCtrl+S");
	idflags.AddTail((void*)(2|(flag<<16)));


	// .. 07.07.07
	CMyLock::GetContextMenu(m_path,lst,idflags);

	return 0;
}
void CDefFileInfo::OnContextMenu(UINT cmd)
{
	if(cmd==1)
		OpenDef(m_path);
	else if(cmd==2)
		CCPPView::m_pView->OnSave();
	else
	{
		// .. 07.07.07
		if(CMyLock::OnContextMenu(m_path,cmd))
			return;
	}

}
