// Info.cpp: implementation of the CInfo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Info.h"
#include "vis1cpp.h"
#include "cppview.h"
#include "resource.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

HTREEITEM CInfo::m_CurItem;
bool CInfo::m_IsSort=true;

CInfo::CInfo(CString name,UINT icon1,UINT icon2)
{
	m_DisplayName=name;
	m_IconCollapse=icon1;
	m_IconExpand=icon2==-1?icon1:icon2;
}

CInfo::~CInfo()
{
}
HTREEITEM CInfo::InsertInTree(HTREEITEM parent)
{
	HTREEITEM item=CCPPView::m_pView->GetTreeCtrl().InsertItem(m_DisplayName,
		m_IconCollapse,m_IconExpand,parent,TVI_LAST);
	CCPPView::m_pView->GetTreeCtrl().SetItemData(item,(DWORD)this);
	return item;
}

void CInfo::ShowContextMenu(CPoint pt)
{
	if (!this)
		return;
	CStringList lst;
	CPtrList idflags;
	int def=GetContextMenu(lst,idflags);
	if(lst.GetCount())
	{
		lst.AddTail("");
		idflags.AddTail((void*)0);
	}

	lst.AddTail("  &");
	idflags.AddTail((void*)(100|(CInfo::m_IsSort?MF_CHECKED<<16:0)));

	lst.AddTail("");
	idflags.AddTail((void*)0);

	lst.AddTail("\tCtrl+C");
	idflags.AddTail((void*)101);

	lst.AddTail("\tAlt+Enter");
	idflags.AddTail((void*)102);

	CMenu menu;
	if(!menu.CreatePopupMenu())
		return;
	CString txt;
	DWORD val;
	UINT id,flags;
	for(POSITION pos=lst.GetHeadPosition(),
		pf=idflags.GetHeadPosition();pos;)
	{
		txt=lst.GetNext(pos);
		val=(DWORD)idflags.GetNext(pf);
		if(txt.IsEmpty())
		{
			id=0;
			flags=MF_SEPARATOR;
		}
		else
		{
			id=LOWORD(val);
			flags=MF_STRING|(val>>16);
		}
		menu.AppendMenu(flags,id,txt);
	}
	if(def>-1)
		menu.SetDefaultItem(def,TRUE);
	UINT ret=TrackPopupMenu(menu.m_hMenu,
		TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_RIGHTBUTTON|TPM_NONOTIFY|TPM_RETURNCMD,
		pt.x,pt.y,0,CCPPView::m_pView->m_hWnd,NULL);
	menu.DestroyMenu();
	if(ret==101)	// Copy
	{
		CCPPView::m_pView->OnCopy();
	}
	else if(ret==100)	// Sort
	{
		m_IsSort=!m_IsSort;
		CCPPView::m_pView->Sort(TVI_ROOT);
	}
	else if(ret==102)
	{
		ShowProperties();
	}
	else if(ret)
		OnContextMenu(ret);
}

void CInfo::ShowProperties()
{
	if(!this)
		return;
	CPropertySheet* sheet=new CPropertySheet(CString(" ")+m_DisplayName);
	int count=0;
	CPtrArray pages;
	GetProp(pages);
	int size=pages.GetSize();
	if(!size)
	{
		pages.Add(new CPropertyPage(IDD_EMPTY));
		size++;
	}
	for(int i=0;i<size;i++)
		sheet->AddPage((CPropertyPage*)pages[i]);
	sheet->DoModal();
	delete sheet;
	for(i=0;i<size;i++)
		delete (CPropertyPage*)pages[i];
}