// InfoWrcSpace.cpp: implementation of the CInfoWrcSpace class.

#include "stdafx.h"
#include "vis1cpp.h"
#include "InfoWrcSpace.h"
#include "cppview.h"
#include "cppdoc.h"
#include ".\1cpp\preprocessor.h"
#include ".\1cpp\MetaDataOfClasses.h"
#include "classinfo.h"
#include "deffileinfo.h"
#include "rootprop.h"
#include "mytextdoc.h"
#include "mymodule.h"
#include "txtget.h"
#include "syntax.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

class COpenDoc:public CDocument
{
public:
	void Open(CString title)
	{
		m_strTitle=title;	//  ,   
		CFrameWnd* pFrame=m_pDocTemplate->CreateNewFrame(this,NULL);
		m_pDocTemplate->InitialUpdateFrame(pFrame,this,TRUE);
	}
};


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CMapStringToOb CInfoWrcSpace::m_mapDef;

CInfoWrcSpace::CInfoWrcSpace():
	CInfo("",TYPE_WRCSPACE_FOLDER)
{
// artbear  ,    defcls@md     
	CMetaDataOfClasses *pMeta=CMetaDataOfClasses::m_oneMetadata;
  pMeta->pathBase1C = pSvc->IBDir();
//end
	CString strDefClsName=pSvc->IBDir()+"defcls.prm";
	CTaskDef* pDef=GetMetaData()->GetTaskDef();
	m_DisplayName=pDef->GetPresent();
	if(m_DisplayName.IsEmpty())
		m_DisplayName=pDef->GetCode();
	CFileStatus st;
	CModuleString str;

	if(!CFile::GetStatus(strDefClsName,st))
	{
		
      strDefClsName = "defcls@MD";
	  if (!str.LoadModule(strDefClsName))
	  {
		  m_DisplayName+=" (defcls.prm  )";    
          return;
	  }
	}
    else
	{  
	  TRY{     
	  CFile file(strDefClsName,CFile::modeRead);

/* // artbear   
	  // artbear    //#include defcls@md   
	  bool bHaveDeflcsInMD = false;
	  {
		CString nameRep = "defcls"; //    
		CMetaDataCont *pMD = GetMetaData();

		CMetaDataObj* pObj=(CMetaDataObj*)pMD->GetCalcVarDef(nameRep);
		if (pObj) //   
			bHaveDeflcsInMD = true;
	  }
	  // end
*/

	  DWORD dwLength = file.GetLength();
	  LPTSTR buff = str.GetBuffer(dwLength);
	  file.Read(buff,dwLength);
	  str.ReleaseBuffer(dwLength);
	  file.Close();

/* // artbear   
	  // artbear    //#include defcls@md   
	  if (bHaveDeflcsInMD)
	  {
		CString strTemp = str;
		strTemp.MakeLower();
		if (strTemp.Find("defcls@md") == -1)
			str = str + "\r\n//#include defcls@md\r\n";
	  }
	  // end
*/
	  }
      CATCH(CFileException, pE)
      {
		  pBkEndUI->DoMessageLine("     ", mmBlackErr);
		  pBkEndUI->DoMessageLine(strDefClsName,mmBlackErr);
      }
      AND_CATCH(CMemoryException,pE)
      {
		  pBkEndUI->DoMessageLine("         CSetOfHierarchy::CSetOfHierarchy()", mmExclamation);
      }
	  END_CATCH
	}

  if (pMeta->pathBase1C.IsEmpty())
  {
    pBkEndUI->DoMessageLine("    BinDir()  bin 1C!", mmBlackErr);	
  }
  else
  {
    CFile file;
    CString strFileNameIni = pSvc->BinDir() + "OXY.ini";    
    if (file.Open(strFileNameIni, CFile::modeRead))
    {          
      DWORD nLength = file.GetLength();
      file.Close();
      char* pBuf = new char[nLength+2];
      int nSize = 0;
      nSize = GetPrivateProfileSection("alias_path", pBuf, nLength+2, strFileNameIni);
      if (nSize > 0)
      {
        CString str;
        for (int i = 0; i < nSize; i++)
        {
          
          if (pBuf[i] == '\0')
          {         
            int nPosEq = str.Find("=");
            if (-1 != nPosEq)
            {
              CString strAlias       = str.Left(nPosEq);
              CString strPathOfAlias = str.Right(str.GetLength() - nPosEq - 1);
              strAlias.TrimLeft(); strAlias.TrimRight();
              strPathOfAlias.TrimLeft(); strPathOfAlias.TrimRight();
              if (strPathOfAlias.GetAt(strPathOfAlias.GetLength()-1) == '\\')              
                pMeta->m_AliasOfPaths[strAlias] = strPathOfAlias.Left(strPathOfAlias.GetLength()-1);              
              else
                pMeta->m_AliasOfPaths[strAlias] = strPathOfAlias;

              //pBkEndUI->DoMessageLine(strAlies, mmBlackErr);	
              //pBkEndUI->DoMessageLine(strPathOfAlies, mmBlackErr);	
            }
            str.Empty();
            if (pBuf[i+1] == '\0')
              break; //  
            continue;
          }
          str += pBuf[i];        
        }
      }          
      delete pBuf;
    }        
  }  

	CRangesOfDescr Ranges;
	CPreprocessor preproc(str,pMeta->m_SymbolOfPreprocessor,pMeta->m_LoadedIncludeFiles,strDefClsName,&Ranges);
		try{
		preproc.Start();
		pMeta->ParsingString(str,Ranges);
		}catch(CPreprocessor::ExeptionPreprocessor &ex)
		{
			CString strErr;        
			strErr.Format("  : %s",strDefClsName);
			pBkEndUI->DoMessageLine(strErr,mmBlackErr);
			strErr = ex.GetErrorString();
			pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
			strErr.Empty();
			if (!ex.GetCodeString().IsEmpty())
			{
			  strErr.Format("(%d) %s",ex.GetNumString(),ex.GetCodeString());
			  pBkEndUI->DoMessageLine(strErr, mmBlackErr);
			}
		}
	CMapStringToString& map=CMetaDataOfClasses::m_oneMetadata->m_FullFileNameOfDescrFile;
	CString Class,Def;
	CStringList *pList;
	for(POSITION pos=map.GetStartPosition();pos;)
	{
		map.GetNextAssoc(pos,Class,Def);
		pList=(CStringList*)m_mapDef[Def];
		if(!pList)
		{
			pList=new CStringList;
			m_mapDef[Def]=pList;
		}
		pList->AddTail(Class);
	}
}

CInfoWrcSpace::~CInfoWrcSpace()
{
	POSITION pos;
	CObject* pOb;
	CString key;
	for(pos=m_mapDef.GetStartPosition();pos;)
	{
		m_mapDef.GetNextAssoc(pos,key,pOb);
		if(pOb)
			delete pOb;
	}
	m_mapDef.RemoveAll();
	CClassInfo *pInfo = NULL;
	for(pos=CClassInfo::m_ClassInfoMap.GetStartPosition();pos;)
	{
		CClassInfo::m_ClassInfoMap.GetNextAssoc(pos,key,(void*&)pInfo);
		delete pInfo;
	}
	CClassInfo::m_ClassInfoMap.RemoveAll();
}

HTREEITEM CInfoWrcSpace::InsertInTree(HTREEITEM parent)
{
	HTREEITEM item=CInfo::InsertInTree(parent);
	CString Def;CObject* pObj;
	for(POSITION pos=m_mapDef.GetStartPosition();pos;)
	{
		m_mapDef.GetNextAssoc(pos,Def,pObj);
		CDefFileInfo* pInfo=new CDefFileInfo(Def);
		pInfo->InsertInTree(item);
	}
	return item;
}

int  CInfoWrcSpace::GetContextMenu(CStringList& lst,CPtrList& idflags)
{
	lst.AddTail("");
	idflags.AddTail((void*)1);
	CDocument* pDoc;
	bool mod=false;

	CString path;
	for(POSITION pos=CMyTextDoc::m_Hooked.GetStartPosition();pos;)
	{
		CMyTextDoc::m_Hooked.GetNextAssoc(pos,path,(CObject*&)pDoc);
		if(pDoc->IsModified()==TRUE)
		{
			mod=true;
			break;
		}
	}
	UINT flag=mod?0:MF_GRAYED;
	lst.AddTail(" \tCtrl+S");
	idflags.AddTail((void*)(2|(flag<<16)));

	lst.AddTail("");
	idflags.AddTail((void*)0);

	lst.AddTail(" ");
	idflags.AddTail((void*)3);

	lst.AddTail("  \tF4");
	flag = CSyntax::GetTotalError() ? 0:MF_GRAYED<<16;
	idflags.AddTail((void*)(4|flag));
	lst.AddTail("  \tShift+F4");
	idflags.AddTail((void*)(5|flag));
	return 0;
}
void CInfoWrcSpace::OnContextMenu(UINT cmd)
{
	if(cmd==1)
		CCPPView::m_pView->Refresh();
	else if(cmd==2)
		CCPPView::m_pView->OnSave();
	else if(cmd==3)
		CSyntax::CompileAll();
	else if(cmd==4 || cmd==5)
		CSyntax::OpenNextError(cmd==5);
}
void CInfoWrcSpace::GetProp(CPtrArray& pArr)
{
	CRootProp *pProp=new CRootProp;
	pArr.Add(pProp);
}
