// MyLock.cpp: implementation of the CMyLock class.
//
//////////////////////////////////////////////////////////////////////
// .. 07.07.07
//E-Mail:progr@hotbox.ru
//////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "vis1cpp.h"
#include "MyLock.h"
#include "deffileinfo.h"
#include "mytextdoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
//char HeaderBuffer[]="!LOCKDATA\r\n";
#define PATH_SIZE		256
#define USER_SIZE		34
#define ROWLOCKSIZE		(PATH_SIZE+USER_SIZE)//\r\n
#define MAX_LOCK_COUNT	4096
#define HEADERSIZE		(MAX_LOCK_COUNT+3)//(MAX_LOCK_COUNT+sizeof(HeaderBuffer)-1)


//////////////////////////////////////////////////////////////////////
CMyLock glAutoDelete;
CMapStringToPtr	CMyLock::m_Locked;
CString			glLockFileName;
HANDLE			glLockFile=0;
CCPPView*		glPViewCtrl=0;
//////////////////////////////////////////////////////////////////////
CMyLockBuffer	glLockBufer;

//////////////////////////////////////////////////////////////////////
CString GetShortName(CString Str)
{
	int nIndex=Str.ReverseFind('\\');
	if(nIndex>0)
	{
		Str=Str.Mid(nIndex+1);
	}
	return Str;
}

//////////////////////////////////////////////////////////////////////
//  
//////////////////////////////////////////////////////////////////////
BOOL FileExist(CString sFileName)
{
	WIN32_FIND_DATA data;
	HANDLE hFile=FindFirstFile(sFileName,&data);
	if(hFile==INVALID_HANDLE_VALUE||hFile==0)
	{
		return FALSE;
	}
	FindClose(hFile);
	return TRUE;
}
char *LoadFromFileBin(CString sFileName,int &size)
{
	if(FileExist(sFileName))
	{
		HANDLE hFile=CreateFile(sFileName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,NULL,NULL);
		if(hFile && hFile != INVALID_HANDLE_VALUE)
		{
			DWORD dwRead;
			size=GetFileSize(hFile,NULL);
			if(size>=0)
			{
				char *pBuf=new char [size+1];
				pBuf[size]=0;
				if(!ReadFile(hFile,pBuf,size,&dwRead,NULL))
				{
					CloseHandle (hFile);
					Msg("     %s",sFileName);
					return 0;
				}
				CloseHandle (hFile);
				return pBuf;
			}
		}
	}

	//Error(ERROR_FILE_OPEN,sFileName.GetBuffer(0));
	return NULL;
}
CString LoadFromFile(CString csFileName)
{
	CString csStr;
	int size; 
	char *s=LoadFromFileBin(csFileName,size);
	if(s)
	{
		memcpy(csStr.GetBuffer(size),s,size);
		csStr.ReleaseBuffer(size);
		delete []s;
	}
	return csStr;
}

int WritoToFile(CString sFileName,CString Str)
{
	HANDLE hFile=CreateFile(sFileName,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,NULL,NULL);
	if(hFile && hFile != INVALID_HANDLE_VALUE)
	{
		DWORD dwWrite=Str.GetLength();
		WriteFile(hFile,Str.GetBuffer(0),dwWrite,&dwWrite,NULL);
		CloseHandle (hFile);
		return 1;
	}
	return 0;
}
int WritoToFileText(CString csCFile,CString Str)
{
	if(FILE *sFile=fopen(csCFile,"wt"))
	{
		fprintf(sFile,"%s",Str);
		fclose(sFile);
		return 1;
	}
	return 0;
}



CString UserName()
{
	CString csUserName;
	unsigned long nBufSize=255;
	GetUserName(csUserName.GetBuffer(nBufSize),&nBufSize);
	csUserName.ReleaseBuffer();

	return csUserName;
}


BOOL Init()
{
	if(glLockFileName.IsEmpty())
	{

		CString csPrmFileName=pSvc->IBDir()+"vislock.prm";
		CString csLockPathName=LoadFromFile(csPrmFileName);
		csLockPathName.TrimRight();
		if(csLockPathName.IsEmpty())
		{
			csLockPathName=pSvc->IBDir();
			WritoToFileText(csPrmFileName,csLockPathName);//   ...
		}

		csLockPathName.TrimRight('\\');
		glLockFileName=csLockPathName+"\\vislock.dat";


		if(!FileExist(glLockFileName))
		{
			HANDLE hFile=CreateFile(glLockFileName,GENERIC_WRITE ,0,NULL,CREATE_ALWAYS,NULL,NULL);
			DWORD dwWrite=HEADERSIZE;
			char pBuf[HEADERSIZE];
			ZeroMemory(pBuf,dwWrite);
			pBuf[HEADERSIZE-2]='\r';
			pBuf[HEADERSIZE-1]='\n';
			WriteFile(hFile,pBuf,dwWrite,&dwWrite,NULL);
			CloseHandle (hFile);
		}

		glLockFile=CreateFile(glLockFileName,GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
			OPEN_EXISTING,NULL,NULL);

		if(glLockFile == 0 || glLockFile == INVALID_HANDLE_VALUE)
		{
			Msg("    : %s",glLockFileName);
			return FALSE;
		}
	}
	

	return TRUE;
}


CString ReadFromLockBufer(int nSize)
{
	DWORD dwRead;
	CString Str;
	char *pBuf=Str.GetBuffer(nSize);
	ZeroMemory(pBuf,nSize);
	BOOL bRes=ReadFile(glLockFile,pBuf,nSize,&dwRead,NULL);
	Str.ReleaseBuffer();
	if(!bRes)
	{
		Msg("      %s",glLockFileName);
	}
	return Str;
}

BOOL FindFromLockBufer(CString csPathName,CString &csUserName,UINT &nAddr)
{
	nAddr=0;
	BOOL bResult=FALSE;

	csPathName=GetShortName(csPathName);
	SetFilePointer(glLockFile,HEADERSIZE,0,FILE_BEGIN);

	int size=GetFileSize(glLockFile,NULL)-HEADERSIZE;
	int nCount=size/ROWLOCKSIZE;
	for(int i=0;i<min(nCount,MAX_LOCK_COUNT);i++)
	{
		CString Str1=ReadFromLockBufer(PATH_SIZE);
		CString Str2=ReadFromLockBufer(USER_SIZE);

		Str1=GetShortName(Str1);
		if(Str1.CompareNoCase(csPathName)==0)
		{
			csUserName=Str2;
			nAddr=i+1;
			bResult=TRUE;
			break;
		}
	}
	return bResult;
}


BOOL WriteToLockBufer(CString csPathName,CString csUserName)
{
	char pBuf[ROWLOCKSIZE];
	ZeroMemory(pBuf,ROWLOCKSIZE);
	memcpy(pBuf,csPathName.GetBuffer(0),csPathName.GetLength());
	memcpy(pBuf+PATH_SIZE,csUserName.GetBuffer(0),csUserName.GetLength());
	pBuf[ROWLOCKSIZE-2]='\r';
	pBuf[ROWLOCKSIZE-1]='\n';

	DWORD dwWrite=ROWLOCKSIZE;
	WriteFile(glLockFile,pBuf,dwWrite,&dwWrite,NULL);


	return TRUE;
}

BOOL BeginGlobalLock()
{
	if(!glLockFile)
		return 0;

	BOOL bResult=FALSE;
	for(int i=0;i<10;i++)
	{
		if(LockFile(glLockFile,0,0,1,0))
		{
			bResult=TRUE;
			break;
		}

		// 100
		Sleep(100);
	}
	if(!bResult)
		Msg("    %s",glLockFileName);
	return bResult;
}

BOOL EndGlobalLock()
{
	BOOL bResult=UnlockFile(glLockFile,0,0,1,0);
	return bResult;
}



//////////////////////////////////////////////////////////////////////
//+1 - 
// 0 -  
//-1 -   
int GetLockStatus(int nAddr)
{
	int nResult=0;
	if(UnlockFile(glLockFile,nAddr,0,1,0))// 
	{
		LockFile(glLockFile,nAddr,0,1,0);
		nResult=-1;
	}
	else
	if(LockFile(glLockFile,nAddr,0,1,0))//  -   
	{
		UnlockFile(glLockFile,nAddr,0,1,0);
		nResult=0;
	}
	else//  
	{
		nResult=1;
	}
	return nResult;
}

BOOL FillLockBufer()
{
	if(!Init())
		return 0; 

	if(!glLockFile)
		return 0;

	BOOL bResult=FALSE;
	glLockBufer.Clear();

	if(BeginGlobalLock())
	{
		BOOL bResult=FALSE;
		SetFilePointer(glLockFile,HEADERSIZE,0,FILE_BEGIN);

		int size=GetFileSize(glLockFile,NULL)-HEADERSIZE;
		int nCount=size/ROWLOCKSIZE;
		for(int i=0;i<min(nCount,MAX_LOCK_COUNT);i++)
		{
			int nAddr=i+1;
			CString Str1=ReadFromLockBufer(PATH_SIZE);
			CString Str2=ReadFromLockBufer(USER_SIZE);

			int nMode=GetLockStatus(nAddr);
			if(!glLockBufer.Get(Str1))
				glLockBufer.Set(Str1,Str2,nMode);
		}


		EndGlobalLock();
	}

	return bResult;
}


//////////////////////////////////////////////////////////////////////
CMyLock::CMyLock()
{

}
CMyLock::~CMyLock()
{
	if(glLockFile)
	{
		CloseHandle(glLockFile);
		DeleteFile(glLockFileName);
	}
}


//////////////////////////////////////////////////////////////////////
int CMyLock::GetLock(CString csPathName,CString &csStatus)
{
	if(csPathName.IsEmpty())
		return 0;

	if(!Init())
		return 1; 



	int nResult=1;
	if(BeginGlobalLock())
	{
		UINT nAddr=0;
		if(FindFromLockBufer(csPathName,csStatus,nAddr))
		{
			nResult=GetLockStatus(nAddr);
		}
		else
		{
			nResult=0;
		}

		EndGlobalLock();
	}


	return nResult;
}
BOOL CMyLock::DoLock(CString csPathName)
{
	if(!Init())
		return 0;

	BOOL bResult=FALSE;

	if(BeginGlobalLock())
	{
		UINT nAddr=0;
		BOOL bFind=FindFromLockBufer(csPathName,CString(),nAddr);

		// -      - ..    !
		if(!bFind)
		{
			nAddr=(GetFileSize(glLockFile,NULL)-HEADERSIZE)/ROWLOCKSIZE+1;
		}

		SetFilePointer(glLockFile,(nAddr-1)*ROWLOCKSIZE+HEADERSIZE,0,FILE_BEGIN);
		bResult=WriteToLockBufer(csPathName,UserName());

		if(bResult)
		{
			
			bResult=LockFile(glLockFile,nAddr,0,1,0);
		}


		EndGlobalLock();
	}


	if(!bResult)
		Msg("   %s",glLockFileName);

	return bResult;
}
BOOL CMyLock::DoUnLock(CString csPathName)
{
	if(!Init())
		return 0;

	BOOL bResult=FALSE;
	if(BeginGlobalLock())
	{
		UINT nAddr=0;
		BOOL bFind=FindFromLockBufer(csPathName,CString(),nAddr);
		if(bFind)
		{
			
			bResult=UnlockFile(glLockFile,nAddr,0,1,0);
		}


		EndGlobalLock();
	}


//	if(!bResult)
//		Msg("   %s",glLockFileName);

	return bResult;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
BOOL CMyLock::OnContextMenu(CString csPathName,UINT cmd)
{
	if(!Init())
		return 0;

	if(cmd==51)
	{
		DoLock(csPathName);
		UpdateTreeCtrl();
		return 1;
	}
	else if(cmd==52)
	{
		DoUnLock(csPathName);
		UpdateTreeCtrl();
		return 1;
	}

	return 0;
}

int CMyLock::GetContextMenu(CString csPathName,CStringList &lst,CPtrList &idflags)
{
	if(!Init())
		return 0;


	lst.AddTail("");
	idflags.AddTail((void*)0);

	UINT flag=0;

	CString csStatusLock;
	int bHasLock=GetLock(csPathName,csStatusLock);

	CString csDoBlock="";
	if(bHasLock!=0)
	{
		if(bHasLock<0)
		{
			// 
			flag=MF_GRAYED<<16;
		}
		else
		{
			//  -  
			flag=MF_DISABLED<<16;
			csDoBlock=": ";
			csDoBlock+=csStatusLock;
		}
	}

	lst.AddTail(csDoBlock);
	idflags.AddTail((void*)(51|flag));

	flag=(bHasLock>=0)?MF_GRAYED<<16:0;
	lst.AddTail("");
	idflags.AddTail((void*)(52|flag));

	return 0;
}

void CMyLock::SetViewCtrl(CCPPView *pCtrl)
{
	glPViewCtrl=pCtrl;
}

void CMyLock::UpdateTreeCtrl(HTREEITEM item)
{
	if(!glPViewCtrl)
		return;
	CTreeCtrl *pCtrl=&glPViewCtrl->GetTreeCtrl();

	while(item)
	{
		CDefFileInfo* pInfo=(CDefFileInfo*)CInfo::GetData(item);
		if(pInfo)
		if(pInfo->m_IconCollapse<=TYPE_CLASS_FOLDER)
		{
			int nMode=0;
			CString csStatus;
			CMyLockBufferInfo* pBlockInfo=glLockBufer.Get(pInfo->m_path);
			if(pBlockInfo)
			{
				csStatus=pBlockInfo->csStatus;
				nMode=pBlockInfo->nMode;
			}

			if(nMode<0)
				pInfo->m_IconCollapse=TYPE_CLASS_FOLDER_OWNLOCK;
			else if(nMode==0)
				pInfo->m_IconCollapse=TYPE_CLASS_FOLDER;
			else if(nMode>0)
				pInfo->m_IconCollapse=TYPE_CLASS_FOLDER_LOCK;

			if(nMode>0)
			{
				pInfo->m_Status=" (: "+csStatus+")";
			}
			else
			{
				pInfo->m_Status="";
			}


			pCtrl->SetItemImage(item,pInfo->m_IconCollapse,pInfo->m_IconCollapse);
		}

		HTREEITEM child=pCtrl->GetChildItem(item);
		if(child)
			UpdateTreeCtrl(child);

		item=pCtrl->GetNextItem(item,TVGN_NEXT);
	}
}


void CMyLock::UpdateTreeCtrl()
{
	if(!glPViewCtrl)
		return;
	CTreeCtrl *pCtrl=&glPViewCtrl->GetTreeCtrl();

	FillLockBufer();
	UpdateTreeCtrl(pCtrl->GetChildItem(pCtrl->GetChildItem(TVI_ROOT)));

	glPViewCtrl->UpdateModified();
}


void CMyLock::CheckForEditLck(HTREEITEM item)
{
	if(!glPViewCtrl)
		return;
	CTreeCtrl *pCtrl=&glPViewCtrl->GetTreeCtrl();

	if(!item)
	{
		CheckForEditLck(pCtrl->GetChildItem(pCtrl->GetChildItem(TVI_ROOT)));
	}
	else
	while(item) 
	{
		CDocument* pDoc;
		CDefFileInfo* pInfo=(CDefFileInfo*)CInfo::GetData(item);
		if(pInfo)
		if(pInfo->m_IconCollapse==TYPE_CLASS_FOLDER)
		{
			if(CMyTextDoc::m_Hooked.Lookup(pInfo->m_path,(CObject*&)pDoc))
				if(pDoc->IsModified())
				{
					int nRet=0;
					void* pOb;
					if(!CMyLock::m_Locked.Lookup(pInfo->m_path,pOb))
					if((nRet=CMyLock::DoLock(pInfo->m_path))==0)
					{
						CMyLock::m_Locked[pInfo->m_path]=(void*)1;
					}

					if(nRet==1)
					{
						CMyLock::m_Locked[pInfo->m_path]=(void*)-1;//  ,  
						pInfo->m_IconCollapse=TYPE_CLASS_FOLDER_OWNLOCK;
						pCtrl->SetItemImage(item,TYPE_CLASS_FOLDER_OWNLOCK,TYPE_CLASS_FOLDER_OWNLOCK);
						return;
					}
				}

		}

		HTREEITEM child=pCtrl->GetChildItem(item);
		if(child)
			CheckForEditLck(child);

		item=pCtrl->GetNextItem(item,TVGN_NEXT);
	}
}




//CMyLockBuffer
CMyLockBuffer::CMyLockBuffer()
{

}

CMyLockBuffer::~CMyLockBuffer()
{
	Clear();
}

void CMyLockBuffer::Clear()
{
	POSITION pos;
	CMyLockBufferInfo* pInfo = NULL;
	for(pos=m_LockBufer.GetStartPosition();pos;)
	{
		CString cl;
		m_LockBufer.GetNextAssoc(pos,cl,(void*&)pInfo);
		if(pInfo)
		{
			delete pInfo;
		}
	}

	m_LockBufer.RemoveAll();
}

CMyLockBufferInfo* CMyLockBuffer::Get(CString csPath)
{
	CMyLockBufferInfo* pInfo;
	if(m_LockBufer.Lookup(GetShortName(csPath),(void*&)pInfo))
		return pInfo;
	else
		return NULL;
}

int CMyLockBuffer::GetMode(CString csPath)
{
	CMyLockBufferInfo* pInfo=Get(csPath);
	if(pInfo)
		return pInfo->nMode;
	else
		return 0;
}

void CMyLockBuffer::Set(CString csPath,CString csStatus,int nMode)
{
	csPath=GetShortName(csPath);

	CMyLockBufferInfo* pInfo=Get(csPath);
	if(!pInfo)
		pInfo=new CMyLockBufferInfo();

	pInfo->csPath=csPath;
	pInfo->csStatus=csStatus;
	pInfo->nMode=nMode;

	m_LockBufer[csPath]=pInfo;
}

