// MyTextDoc.cpp : implementation file
//

#include "stdafx.h"
#include "vis1cpp.h"
#include "MyTextDoc.h"
#include "resource.h"
#include "MyLock.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
CMapStringToPtr CMyTextDoc::m_pVtableMap;
CMapStringToPtr CMyTextDoc::m_OnCloseMap;
CMapStringToPtr CMyTextDoc::m_DoSaveMap;
CMapStringToOb  CMyTextDoc::m_Hooked;
/////////////////////////////////////////////////////////////////////////////
// CMyTextDoc

IMPLEMENT_DYNCREATE(CMyTextDoc, CDocument)

CMyTextDoc::CMyTextDoc()
{
}

CMyTextDoc::~CMyTextDoc()
{
}


BEGIN_MESSAGE_MAP(CMyTextDoc, CDocument)
	//{{AFX_MSG_MAP(CMyTextDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyTextDoc serialization

void CMyTextDoc::OnCloseDocumentMy() 
{
	m_Hooked.RemoveKey(m_strPathName);


	// ..
	void* pOb=0;
	if(CMyLock::m_Locked.Lookup(m_strPathName,pOb))
	{
		if((int)pOb==-1)
			CMyLock::DoUnLock(m_strPathName);
		CMyLock::m_Locked.RemoveKey(m_strPathName);
	}


	PtrConv c;
	c.pV=m_OnCloseMap[GetRuntimeClass()->m_lpszClassName];
	(this->*c.pOnClose)();
}

BOOL CMyTextDoc::DoFileSaveMy()
{

	// ..
	void* pOb=0;
	CMyLock::m_Locked.Lookup(m_strPathName,pOb);
	if((int)pOb==1)
		return 0;

	CString title=m_strTitle;
	PtrConv c;
	c.pV=m_DoSaveMap[GetRuntimeClass()->m_lpszClassName];
	BOOL ret=(this->*c.pDoSave)();
	m_strTitle=title;
	
	POSITION pos=GetFirstViewPosition();
	GetNextView(pos)->GetParentFrame()->SetWindowText(m_strTitle);
	CCPPView::m_pView->UpdateClass(this);
	return ret;
}
void CMyTextDoc::HookDoc(CDocument *pDoc,CString title,HICON hIcon)
{
	CObject* pOb;
	CString path;
	long id=CConfigCont::DocumentToID(pDoc,path);
	if(id>0)
		CConfigCont::DocumentToPath(pDoc,path);
	else
		path=pDoc->GetPathName();
	if(m_Hooked.Lookup(path,pOb))
		return;
	((CMyTextDoc*)pDoc)->ST(title);
	POSITION pos=pDoc->GetFirstViewPosition();
	CFrameWnd* pFrame=pDoc->GetNextView(pos)->GetParentFrame();
	pFrame->SetWindowText(title);
	if(hIcon)
		pFrame->SetIcon(hIcon,FALSE);
	else
	{
		pFrame->SetIcon(LoadIcon(hMyInst,(LPCTSTR)IDI_CLASS),FALSE);
	}

	CString Class=pDoc->GetRuntimeClass()->m_lpszClassName;
	DWORD* pVtable;
	if(!m_pVtableMap.Lookup(Class,(void*&)pVtable))
	{
		DWORD *pVtableDoc=*(DWORD**)pDoc,*ptr=pVtableDoc;
		while(*++ptr);
		pVtable=new DWORD[ptr-pVtableDoc];
		m_pVtableMap[Class]=(void*)pVtable;
		int i=0;
		while(pVtableDoc!=ptr)
			pVtable[i++]=*pVtableDoc++;
		PtrConv c;
		c.pV=(void*)*(pVtable+0x29);
		m_DoSaveMap[Class]=c.pV;
		c.pDoSave=(PFDOFSAVE)&CMyTextDoc::DoFileSaveMy;
		*(pVtable+0x29)=(DWORD)c.pV;

		c.pV=(void*)*(pVtable+0x21);
		m_OnCloseMap[Class]=c.pV;
		c.pOnClose=(PFONCLOSE)&CMyTextDoc::OnCloseDocumentMy;
		*(pVtable+0x21)=(DWORD)c.pV;
	}
	*((DWORD**)pDoc)=pVtable;
	m_Hooked[pDoc->GetPathName()]=pDoc;


	// ..
	CString csLockStatus;
	int nLockMode=CMyLock::GetLock(path,csLockStatus);
	if(nLockMode==1)
	{
		CMyLock::m_Locked[pDoc->GetPathName()]=(void*)nLockMode;
		Msg(" \"%s\"   \"%s\".   !",title,csLockStatus);
	}
}
