// vis1cpp.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "vis1cpp.h"
#include <afxdllx.h>
#include "cppdoc.h"
#include "cppview.h"
#include "moduleparser.h"
#include "mytextdoc.h"
#include "resource.h"
#include "txtget.h"
#include "syntax.h"

#include "WrapperForSyntaxCheck.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CConfigService* pSvc;
HINSTANCE hMyInst;

class CMetaDataCont * pMetaDataCont = NULL;

static AFX_EXTENSION_MODULE Vis1cppDLL = { NULL, NULL };

void OnCreateCfgWindow(CWnd* pWnd)
{
	if(CCPPView::m_pView)
		return;
	pSvc->AddConfigTab("1C++",LoadIcon(hMyInst,(LPCTSTR)IDI_WRCCPACE),
		RUNTIME_CLASS(CCPPDoc),RUNTIME_CLASS(CCPPView));
}

extern "C" _declspec(dllexport) void SetConvigService(void* p)
{
	pSvc=(CConfigService*)p;
	pSvc->AddConfigEventHandler(CFG_ON_CREATE_CFG_WND,OnCreateCfgWindow);
	pSvc->RegisterPanelClass("1C++",RUNTIME_CLASS(CCPPView),(HICON)LoadImage(hMyInst,(LPCTSTR)IDI_WRCCPACE,IMAGE_ICON,16,16,0));

}

extern "C" int APIENTRY DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
static int iRefCount;

	UNREFERENCED_PARAMETER(lpReserved);
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		if (!AfxInitExtensionModule(Vis1cppDLL, hInstance))
			return 0;
		++iRefCount;

		new CDynLinkLibrary(Vis1cppDLL);
		hMyInst=hInstance;
		pBkEndUI=GetBkEndUI();
		CModuleParser::InitMaps();

		// TODO    
		// TODO          
		//
		static const char* keys[]={"class","","void","","","",
			"","this","", "", ""
			};
		for(int i=0;i<sizeof(keys)/sizeof(keys[0]);i++)
			CBLModule::AddToKeywordColorList(keys[i]);
		CTxtGet::Init();

		CWrapperForSyntaxCheck::SetHooks();

		/*
        CRuntimeClass* pFrameClass=(CRuntimeClass*)GetProcAddress(
            GetModuleHandle("frame.dll"),
            "?classCPopupFrame@CPopupFrame@@2UCRuntimeClass@@B");
        //      
        HINSTANCE h1CRes=AfxGetResourceHandle();
        AfxSetResourceHandle(hInstance);
        // 
        AfxGetApp()->AddDocTemplate(new CTemplate7(
            IDR_MAIN,
            RUNTIME_CLASS(CCPPDoc),
            pFrameClass,
            RUNTIME_CLASS(CCPPView)));
        AfxSetResourceHandle(h1CRes);

        //      ToolBarManager
        //        /  
        GetToolBarManager()->FUNC3(IDR_MAIN, "Visual 1C++", IDR_MAIN, IDR_MAIN, NULL, 0xE81D, 0, 1, 0x3F800001, 0x96);
		*/
	}	
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		// .        dwReason == DLL_PROCESS_DETACH
		// , ,         1++

		AfxTermExtensionModule(Vis1cppDLL);
		
		CWrapperForSyntaxCheck::DestroyHooks();
	}

	return 1;
}

void Log(const char* format,MessageMarker mark,bool MsgBox,...)
{
	va_list arg;
	va_start(arg,MsgBox);
	CString txt;
	txt.FormatV(format,arg);
	va_end(arg);
	if(MsgBox)
		AfxMessageBox(txt);
	else
		pBkEndUI->DoMessageLine(txt,mark);
}