// 1cheaders.inl

//    
#pragma comment(linker,"/FILEALIGN:512")

//  
#pragma comment (lib,"../1cheaders/libs/basic.lib")
#pragma comment (lib,"../1cheaders/libs/bkend.lib")
#pragma comment (lib,"../1cheaders/libs/blang.lib")
#pragma comment (lib,"../1cheaders/libs/br32.lib")
#pragma comment (lib,"../1cheaders/libs/dbeng32.lib")
#pragma comment (lib,"../1cheaders/libs/editr.lib")
#pragma comment (lib,"../1cheaders/libs/frame.lib")
#pragma comment (lib,"../1cheaders/libs/moxel.lib")
#pragma comment (lib,"../1cheaders/libs/rgproc.lib")
#pragma comment (lib,"../1cheaders/libs/seven.lib")
#pragma comment (lib,"../1cheaders/libs/txtedt.lib")
#pragma comment (lib,"../1cheaders/libs/type32.lib")
#pragma comment (lib,"../1cheaders/libs/userdef.lib")

CApp7 *App;
CBkEndUI *UI;
CMetaDataCont *MD;
IzlibEngine *zlib;

int Init1CGlobal()
{
	UI=GetBkEndUI();
	if (!UI) return Debug("Fatal> Filed to get 1C user iterface object\n"),0;

	//   Debug run-time libraries  _DEBUG,  AfxGetApp   NULL
	//    __DEBUG

	App=(CApp7*)AfxGetApp();
	if (AssertPtr(App,"Fatal> Filed to get 1C application object. See comments in Init1CGlobal")) return 0;

	MD=GetMetaData();
	if (AssertPtr(MD,"Fatal> Failed to get 1C metadata object")) return 0;

	zlib=App->get_zlibEngine();
	if (AssertPtr(zlib,"Fatal> Failed to get 1C zlig engine object")) return 0;

	//zlib->AddRef(); //       1,    

	return 1;
}

void Done1CGlobal()
{
	//zlib->Release(); //       1,    
}

CString GetErrorDescr(DWORD lastError)
{
	if (!lastError)
		lastError=GetLastError();

	CString errMsg;
	errMsg.Format("  Windows: 0x%X",lastError);

	LPTSTR lpMsgBuf;
	if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,lastError,MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),(LPTSTR)&lpMsgBuf,0,NULL))
	{
		errMsg+="\r\n";
		errMsg+=lpMsgBuf;
		LocalFree(lpMsgBuf);
	}

	return errMsg;
}

void DoDebug(char *Format,...)
{
	#if defined _AFXDLL	|| defined _WINDLL
		CString Msg;
		Msg.FormatV(Format,(va_list)(&Format+1));
	#else
		static char Msg[0x4000];
		vsprintf(Msg,Format,(va_list)(&Format+1));
	#endif
	OutputDebugString(Msg);
}

void StatusLine(LPCSTR Format,...)
{
	CString Msg;
	Msg.FormatV(Format,(va_list)(&Format+1));
	UI->DoStatusLine(Msg);
}

void SMessage(MessageMarker Icon,LPCSTR Msg)
{
#ifdef __DEBUG
	OutputDebugString("Message> ");
	OutputDebugString(Msg);
	OutputDebugString("\n");
#endif
	UI->DoMessageLine(Msg,Icon);
}

void SMessage(LPCSTR Msg)
{
	SMessage(mmBlueTriangle,Msg);
}

void Message(LPCSTR Format,...)
{
	CString Msg;
	Msg.FormatV(Format,(va_list)(&Format+1));
	SMessage(mmBlueTriangle,Msg);
}

void Message(MessageMarker Icon,LPCSTR Format,...)
{
	CString Msg;
	Msg.FormatV(Format,(va_list)(&Format+1));
	SMessage(Icon,Msg);
}

void SRuntimeError(LPCSTR Msg)
{
	if (CBLModule::GetExecutedModule())
	{
	#ifdef __DEBUG
		OutputDebugString("Error> ");
		OutputDebugString(Msg);
		OutputDebugString("\n");
	#endif
	 	CBLModule::RaiseExtRuntimeError(Msg,mmRedErr);
	}
	else
		SMessage(mmRedErr,Msg);
}

void RuntimeError(LPCSTR Format,...)
{
	CString Msg;
	Msg.FormatV(Format,(va_list)(&Format+1));
	SRuntimeError(Msg);
}
