// addin.hpp
// (c)  
//   1   IInitDone.
//    COM  .

#pragma once
#pragma pack(push, 8)

#include <comdef.h>

struct __declspec(uuid("ab634001-f13d-11d0-a459-004095e1daea"))
IInitDone : IUnknown
{
	STDMETHOD(Init)(IDispatch *pConnection) = 0;
	STDMETHOD(Done)() = 0;
	STDMETHOD(GetInfo)(SAFEARRAY **pInfo) = 0;
};

struct __declspec(uuid("ab634002-f13d-11d0-a459-004095e1daea"))
IPropertyProfile : IPropertyBag
{
	STDMETHOD(RegisterProfileAs)(BSTR bstrProfileName) = 0;
};

struct __declspec(uuid("ab634004-f13d-11d0-a459-004095e1daea"))
IAsyncEvent : IUnknown
{
	STDMETHOD(SetEventBufferDepth)(long lDepth) = 0;
	STDMETHOD(GetEventBufferDepth)(long *plDepth) = 0;
	STDMETHOD(ExternalEvent)(BSTR bstrSource, BSTR bstrMessage, BSTR bstrData) = 0;
	STDMETHOD(CleanBuffer)() = 0;
};

struct __declspec(uuid("ab634003-f13d-11d0-a459-004095e1daea"))
ILanguageExtender : IUnknown
{
	STDMETHOD(RegisterExtensionAs)(BSTR *bstrExtensionName) = 0;
	STDMETHOD(GetNProps)(long *plProps) = 0;
	STDMETHOD(FindProp)(BSTR bstrPropName, long *plPropNum) = 0;
	STDMETHOD(GetPropName)(long lPropNum, long lPropAlias, BSTR *pbstrPropName) = 0;
	STDMETHOD(GetPropVal)(long lPropNum, VARIANT *pvarPropVal) = 0;
	STDMETHOD(SetPropVal)(long lPropNum, VARIANT *varPropVal) = 0;
	STDMETHOD(IsPropReadable)(long lPropNum, long *pboolPropRead) = 0;
	STDMETHOD(IsPropWritable)(long lPropNum, long *pboolPropWrite) = 0;
	STDMETHOD(GetNMethods)(long *plMethods ) = 0;
	STDMETHOD(FindMethod)(BSTR bstrMethodName, long *plMethodNum) = 0;
	STDMETHOD(GetMethodName)(long lMethodNum, long lMethodAlias, BSTR *pbstrMethodName) = 0;
	STDMETHOD(GetNParams)(long lMethodNum, long *plParams) = 0;
	STDMETHOD(GetParamDefValue)(long lMethodNum, long lParamNum, VARIANT *pvarParamDefValue) = 0;
	STDMETHOD(HasRetVal)(long lMethodNum, long *pboolRetValue) = 0;
	STDMETHOD(CallAsProc)(long lMethodNum, SAFEARRAY **paParams) = 0;
	STDMETHOD(CallAsFunc)(long lMethodNum, VARIANT *pvarRetValue, SAFEARRAY **paParams) = 0;
};

struct __declspec(uuid("ab634005-f13d-11d0-a459-004095e1daea"))
IStatusLine : IUnknown
{
	STDMETHOD(SetStatusLine)(BSTR bstrStatusLine) = 0;
	STDMETHOD(ResetStatusLine)() = 0;
};

struct __declspec(uuid("efe19ea0-09e4-11d2-a601-008048da00de"))
IExtWndsSupport : IUnknown
{
	STDMETHOD(GetAppMainFrame)(wireHWND *hwnd) = 0;
	STDMETHOD(GetAppMDIFrame)(wireHWND *hwnd) = 0;
	STDMETHOD(CreateAddInWindow)(
		BSTR bstrProgID,
		BSTR bstrWindowName,
		long dwStyles,
		long dwExStyles,
		struct tagRECT *rctl,
		long Flags,
		wireHWND *pHwnd,
		IDispatch **pDisp) = 0;
};

_COM_SMARTPTR_TYPEDEF(IInitDone, __uuidof(IInitDone));
_COM_SMARTPTR_TYPEDEF(IPropertyProfile, __uuidof(IPropertyProfile));
_COM_SMARTPTR_TYPEDEF(IAsyncEvent, __uuidof(IAsyncEvent));
_COM_SMARTPTR_TYPEDEF(ILanguageExtender, __uuidof(ILanguageExtender));
_COM_SMARTPTR_TYPEDEF(IStatusLine, __uuidof(IStatusLine));
_COM_SMARTPTR_TYPEDEF(IExtWndsSupport, __uuidof(IExtWndsSupport));

extern "C" const GUID __declspec(selectany) IID_IInitDone = 
    {0xab634001,0xf13d,0x11d0,{0xa4,0x59,0x00,0x40,0x95,0xe1,0xda,0xea}};
extern "C" const GUID __declspec(selectany) IID_IPropertyProfile =
    {0xab634002,0xf13d,0x11d0,{0xa4,0x59,0x00,0x40,0x95,0xe1,0xda,0xea}};
extern "C" const GUID __declspec(selectany) IID_IAsyncEvent =
    {0xab634004,0xf13d,0x11d0,{0xa4,0x59,0x00,0x40,0x95,0xe1,0xda,0xea}};
extern "C" const GUID __declspec(selectany) IID_ILanguageExtender =
    {0xab634003,0xf13d,0x11d0,{0xa4,0x59,0x00,0x40,0x95,0xe1,0xda,0xea}};
extern "C" const GUID __declspec(selectany) IID_IStatusLine =
    {0xab634005,0xf13d,0x11d0,{0xa4,0x59,0x00,0x40,0x95,0xe1,0xda,0xea}};
extern "C" const GUID __declspec(selectany) IID_IExtWndsSupport =
    {0xefe19ea0,0x09e4,0x11d2,{0xa6,0x01,0x00,0x80,0x48,0xda,0x00,0xde}};
extern "C" const GUID __declspec(selectany) IID_IPropertyLink =
    {0x52512a61,0x2a9d,0x11d1,{0xa4,0xd6,0x00,0x40,0x95,0xe1,0xda,0xea}};

#pragma pack(pop)

// **************************************************************************

typedef HRESULT STDAPICALLTYPE TAPIFunc();
typedef TAPIFunc *PAPIFunc;

typedef HRESULT STDAPICALLTYPE TDllGetClassObject(const CLSID&, const IID&, void **);
typedef TDllGetClassObject *PDllGetClassObject;

typedef HRESULT STDAPICALLTYPE TCLSIDFromProgID(LPCOLESTR, LPCLSID);
typedef TCLSIDFromProgID *PCLSIDFromProgID;

typedef HRESULT STDAPICALLTYPE TCoCreateInstance(REFCLSID, LPUNKNOWN, DWORD, REFIID, LPVOID*);
typedef TCoCreateInstance *PCoCreateInstance;

#include "mytraps.hpp"

namespace addin{

class CTrapLoadVK
{
protected:
	friend class COneAddinImpl;

	static CTrapLoadVK* &This()
	{
		static CTrapLoadVK* pThis = 0;
		return pThis;
	}

	const CLSID& rClsID;
	const IInitDone* pAddin;

	traps::CTrapAddr trapCLSIDFromProgID;
	traps::CTrapAddr trapCoCreateInstance;

	//   

	static HRESULT STDAPICALLTYPE apiCLSIDFromProgID(LPCOLESTR lpszProgID, LPCLSID pclsid)
	{
		*pclsid=This()->rClsID;
		return S_OK;
	}
	static HRESULT STDAPICALLTYPE apiCoCreateInstance(REFCLSID rclsid, LPUNKNOWN pUnkOuter,
		DWORD dwClsContext, REFIID riid, LPVOID *ppv)
	{
		//    ,    rClsID,    
		//        (        
		//  ProgID   ,        1 )
		//   !

		*ppv=const_cast<IInitDone*>(This()->pAddin);
		delete This();
		return S_OK;
	}

	//     

	//       
	//   ,  ,     

	CTrapLoadVK(const IInitDone* aAddin, const CLSID& aClsID):
		rClsID(aClsID), pAddin(aAddin),
		trapCLSIDFromProgID("seven.dll", "ole32.dll", "CLSIDFromProgID", apiCLSIDFromProgID),
		trapCoCreateInstance("seven.dll", "ole32.dll", "CoCreateInstance", apiCoCreateInstance)
	{
		This()=this;
		Debug("Trap\n");
	}
	~CTrapLoadVK()
	{
		Debug("UnTrap\n");
	}
};

//  uuid      API    (  progid)  CTrapLoadVK  
//    ,      !

class __declspec(uuid("11111111-1111-1111-1111-111111111111")) COneAddinImpl: public IInitDone
{
protected:
	static COneAddinImpl* &This()
	{
		static COneAddinImpl* pThis = 0;
		return pThis;
	}

	//  IUnknown

	STDMETHOD(QueryInterface)(REFIID riid, void **ppvObject)
	{
		if (riid==IID_IInitDone)
			*ppvObject=static_cast<IInitDone*>(this);
		else if (riid==IID_IUnknown)
			*ppvObject=static_cast<IUnknown*>(this);
		else
			return E_NOINTERFACE;
		return S_OK;
	}
	STDMETHOD_(ULONG, AddRef)()
	{
		return 1;
	}
	STDMETHOD_(ULONG, Release)()
	{
		return 1;
	}

	//  IInitDone

    STDMETHOD(Init)(IDispatch *pConnection)
	{
		Debug("Init COneAddinImpl\n");
		return S_OK;
	}
    STDMETHOD(Done)()
	{
		Debug("Done COneAddinImpl\n");
		return S_OK;
	}
    STDMETHOD(GetInfo)(SAFEARRAY **pInfo)
	{
		long lInd = 0;
		VARIANT varVersion;
		V_VT(&varVersion) = VT_I4;
		V_I4(&varVersion) = 2000;
		SafeArrayPutElement(*pInfo,&lInd,&varVersion);
		return S_OK;
	}

	//  ,  

	COneAddinImpl()
	{
		This()=this;
		new CTrapLoadVK(this,__uuidof(COneAddinImpl));
	}

public:
	static void OnProcessAttach()
	{
		new COneAddinImpl();
	}
	static void OnProcessDetach()
	{
		delete This();
	}
};

struct CAddinInfo
{
	CString strProgID;
	CLSID clsid;
	PDllGetClassObject pFunc;

	CAddinInfo():pFunc(NULL) {}
	CAddinInfo(LPCSTR pStart, LPCSTR pEnd):strProgID(pStart, pEnd-pStart), pFunc(NULL)
	{
		strProgID.MakeLower();
	}
};
typedef CArray<CAddinInfo, CAddinInfo> CAddinArray;

class CAddinManager
{
protected:
	static CAddinManager* &This()
	{
		static CAddinManager* pThis = 0;
		return pThis;
	}

	CAddinArray addins;
	traps::CTrapAddr trapClassFromProgID;
	traps::CTrapAddr trapCoCreateInstance7;
	traps::CTrapAddr trapCoCreateInstanceF;

	CAddinManager():
		trapClassFromProgID("seven.dll", "ole32.dll", "CLSIDFromProgID", apiClassFromProgID),
		trapCoCreateInstance7("seven.dll", "ole32.dll", "CoCreateInstance", apiCoCreateInstance7),
		trapCoCreateInstanceF("frame.dll", "ole32.dll", "CoCreateInstance", apiCoCreateInstanceF)
	{
		This()=this;
	}
	
	HRESULT ClassFromProgID(LPCOLESTR bstrPropgID, LPCLSID pClsID)
	{
		USES_CONVERSION;
		CString strProgID=OLE2A(bstrPropgID);
		strProgID.MakeLower();
		for (int i=0;i<addins.GetSize();i++)
			if (strProgID==addins[i].strProgID)
			{
				*pClsID=addins[i].clsid;
				return S_OK;
			}

		return (trapClassFromProgID.OldFunc(apiClassFromProgID))(bstrPropgID, pClsID);
	}
	HRESULT CoCreateInstance(REFCLSID clsid, LPUNKNOWN pUnk, DWORD dwCtx, REFIID iid, LPVOID* ppRet, PCoCreateInstance pOldCoCreateInstance)
	{
		for (int i=0;i<addins.GetSize();i++)
			if (InlineIsEqualGUID(clsid, addins[i].clsid))
			{
				IClassFactoryPtr pFactory;
				HRESULT Result=addins[i].pFunc(clsid, IID_IClassFactory, reinterpret_cast<LPVOID*>(&pFactory));
				if (Result)	return Result;
				return pFactory->CreateInstance(pUnk, iid, ppRet);
			}

		return pOldCoCreateInstance(clsid, pUnk, dwCtx, iid, ppRet);
	}
	
	static HRESULT STDAPICALLTYPE apiClassFromProgID(LPCOLESTR bstrPropgID, LPCLSID pClsID)
	{
		return This()->ClassFromProgID(bstrPropgID, pClsID);
	}
	static HRESULT STDAPICALLTYPE apiCoCreateInstance7(REFCLSID clsid, LPUNKNOWN pUnk, DWORD dwCtx, REFIID iid, LPVOID* ppRet)
	{
		return This()->CoCreateInstance(clsid, pUnk, dwCtx, iid, ppRet, This()->trapCoCreateInstance7.OldFunc(apiCoCreateInstance7));
	}
	static HRESULT STDAPICALLTYPE apiCoCreateInstanceF(REFCLSID clsid, LPUNKNOWN pUnk, DWORD dwCtx, REFIID iid, LPVOID* ppRet)
	{
		return This()->CoCreateInstance(clsid, pUnk, dwCtx, iid, ppRet, This()->trapCoCreateInstance7.OldFunc(apiCoCreateInstance7));
	}

	void AddAddinsEx(CAddinArray& newAddins)
	{
		for (int i=0;i<newAddins.GetSize();i++)
		{
			for (int j=0;j<addins.GetSize();j++)
				if (addins[j].strProgID==newAddins[i].strProgID)
					break;

			if (j==addins.GetSize())
				addins.Add(newAddins[i]);
		}
	}

public:
	static void AddAddins(CAddinArray& newAddins)
	{
		if (!This()) new CAddinManager;
		This()->AddAddinsEx(newAddins);
	}
	static void Init()
	{
		//    
	}
	static void Done()
	{
		if (This()) delete This();
	}
};

} // namespace addin

using addin::CAddinManager;
using addin::COneAddinImpl;
