// blloader.cpp
// (c)  , telepat@inbox.ru
#include "StdAfx.h"
#include "../_mycommon/mycontimpl.hpp"
#include "../_mycommon/myaddin.hpp"

enum errCodes
{
	errSuccess,
	errBadParam,
	errBadFile,
	errNoProgIDs,
	wrnNotAllClsIDs,
	errNoClsIDs,
	errNoGetObject,
};

class CLoadResult: public CContextImpl<CLoadResult, CNoCreate<CLoadResult> >
{
protected:
	int m_iResult;
	CString m_strResult;

	CLoadResult(CValue& Value, int iResult, LPCSTR strResult):
		m_iResult(iResult), m_strResult(strResult)
	{
		Value.AssignContext(this);
		DecrRef();
	}

public:
	BL_BEGIN_CONTEXT("ExecuteResult", "")

		BL_PROP_R(ErrorCode, "")
		{
			Value=m_iResult;
		}

		BL_PROP_R(Result, "")
		{
			Value=m_strResult;
		}

	BL_END_CONTEXT()

	static void AssignResult(CValue& Value, int iResult, LPCSTR strResult)
	{
		new CLoadResult(Value, iResult, strResult);
	}
};

BL_INIT_CONTEXT(CLoadResult);

// **************************************************************************

#define SYMB(n) static_cast<BYTE>(n)

//    (?),  if 0

#if 1
	#pragma warning(disable: 4035)

	__declspec(naked) LPCSTR FindChar(LPCSTR Str/*esp+4*/,CHAR Char/*esp+8*/)
	{
		_asm
		{
			mov eax,/*Source*/[esp+4 + 0]
			mov dl,/*Char*/[esp+8 + 0]
__loop:
			mov cl,[eax]
			test cl,cl
			je short __end
			inc eax
			cmp cl,dl
			jne short __loop
			dec eax
__end:
			ret
		}
	}

	#pragma warning(default: 4035)
#else
	LPCSTR FindChar(LPCSTR Str,CHAR Char)
	{
		while (SYMB(*Str) && SYMB(*Str)!=SYMB(Char)) Str++;
		return Str;
	}
#endif

// **************************************************************************

class CBLLoader: public CContextImpl<CBLLoader>
{
public:
	BL_BEGIN_CONTEXT("AddinLoader", "")

		BL_FUNC(LoadAddin, "", 2)
		{
			LoadAddin(Value, *Params[0], *Params[1]);
		}
		
		BL_FUNC(GetLoadCode, "", 1)
		{
			GetLoadCode(Value, *Params[0]);
		}

	BL_END_CONTEXT()

protected:
	void LoadAddin(CValue& Value, CValue& pFile, CValue& pProgClassID)
	{
		if (pFile.type!=2)
		{
			CLoadResult::AssignResult(Value, errBadParam, "   ");
			return;
		}
		if (pProgClassID.type!=2)
		{
			CLoadResult::AssignResult(Value, errBadParam, "   ");
			return;
		}

		addin::CAddinArray arrIDs;
		CString strClsIDs=pProgClassID.GetString();
		for (LPCSTR pStart=strClsIDs, pEnd;;)
		{
			pEnd=FindChar(pStart,'\r');
			if (pEnd>pStart+43)
			{
				CString strLine(pStart, pEnd-pStart);
				LPCSTR pEqual=FindChar(strLine,'=');
				if (SYMB(*pEqual))
				{
					addin::CAddinInfo info(strLine, pEqual);
					if (info.strProgID.Find("addin.")==0 && UuidFromString((BYTE*)(const_cast<char*>(pEqual+1)), &info.clsid)==RPC_S_OK)
						arrIDs.Add(info);
				}
			}
			while (SYMB(*pEnd) && SYMB(*pEnd)<32) pEnd++;
			if (!SYMB(*pEnd)) break;
			pStart=pEnd;
		}
		if (!arrIDs.GetSize())
		{
			CLoadResult::AssignResult(Value, errNoClsIDs, "   ");
			return;
		}

		CString strFileName=pFile.GetString();
		
		BOOL bNoInstance=FALSE;
		HINSTANCE hModule=GetModuleHandle(strFileName);
		if (!hModule)
		{
			bNoInstance=TRUE;
			hModule=LoadLibrary(strFileName);
			if (!hModule)
			{
				CString errMsg="   \"";
				errMsg+=strFileName;
				errMsg+="\"\r\n";
				errMsg+=GetErrorDescr();
				CLoadResult::AssignResult(Value, errBadFile, errMsg);
				return;
			}
		}

		PDllGetClassObject pFunc=reinterpret_cast<PDllGetClassObject>(GetProcAddress(hModule, "DllGetClassObject"));
		if (!pFunc)
		{
			CLoadResult::AssignResult(Value, errNoGetObject, "   DllGetClassObject");
			if (bNoInstance) FreeLibrary(hModule);
			return;
		}

		for (int i=0;i<arrIDs.GetSize();i++)
			arrIDs[i].pFunc=pFunc;

		CAddinManager::AddAddins(arrIDs);

		UINT loaded=0;
		CString strResult=":\r\n";
		for (i=0;i<arrIDs.GetSize();i++)
			if (App->AttachAddInDLL(arrIDs[i].strProgID))
			{
				if (loaded++) strResult+="\r\n";
				strResult+=arrIDs[i].strProgID;
			}
		CLoadResult::AssignResult(Value, loaded<arrIDs.GetSize() ? wrnNotAllClsIDs : errSuccess, strResult);
		return;
	}

	int GetCLSID(CStringArray& arrProgIDs, CStringArray& arrCLSIDs)
	{
		int nsize=arrProgIDs.GetSize(), progIDs=0;
		for (int i=0;i<nsize;i++)
		{
			CLSID clsid;
			if (CLSIDFromProgID(_bstr_t(arrProgIDs[i]), &clsid)==S_OK)
			{
				BYTE* pString;
				if (UuidToString(&clsid, &pString)==RPC_S_OK)
				{
					arrCLSIDs[i]=(reinterpret_cast<LPCSTR>(pString));
					RpcStringFree(&pString);
					progIDs++;
				}
			}
		}
		return progIDs;
	}

	void GetLoadCode(CValue& Value, CValue& pFile)
	{
		if (pFile.type!=2)
		{
			CLoadResult::AssignResult(Value, errBadParam, "  ");
			return;
		}

		CString strFileName=pFile.GetString();

		BOOL bNoInstance=FALSE;
		HINSTANCE hModule=GetModuleHandle(strFileName);
		if (!hModule)
		{
			bNoInstance=TRUE;
			hModule=LoadLibrary(strFileName);
			//hModule=LoadLibraryEx(strFileName, NULL, LOAD_LIBRARY_AS_DATAFILE);
			if (!hModule)
			{
				CString errMsg="   \"";
				errMsg+=strFileName;
				errMsg+="\"\r\n";
				errMsg+=GetErrorDescr();
				CLoadResult::AssignResult(Value, errBadFile, errMsg);
				return;
			}
		}
		
		char buffer[0x1000];
		if (!LoadString(hModule, 100, buffer, sizeof(buffer)))
			_splitpath(strFileName, NULL, NULL, buffer, NULL);

		CStringArray arrProgIDs, arrCLSIDs;
		for (LPCSTR pStart=buffer, pEnd;;)
		{
			pEnd=FindChar(pStart,'|');
			if (pEnd>pStart)
				arrProgIDs.Add(CString("Addin.")+CString(pStart, pEnd-pStart));
			if (!SYMB(*pEnd)) break;
			pStart=++pEnd;
		}

		int nProgIDs=arrProgIDs.GetSize();
		if (!nProgIDs)
		{
			CLoadResult::AssignResult(Value, errNoProgIDs, "  ProgID");
			if (bNoInstance) FreeLibrary(hModule);
			return;
		}
		arrCLSIDs.SetSize(nProgIDs);
		
		int nClassIDs=GetCLSID(arrProgIDs, arrCLSIDs);
		if (nClassIDs<nProgIDs) //    ProgID   CLSID
		{
			PAPIFunc DllRegisterServer=reinterpret_cast<PAPIFunc>(GetProcAddress(hModule, "DllRegisterServer"));
			if (DllRegisterServer)
			{
				DllRegisterServer();
				nClassIDs=GetCLSID(arrProgIDs, arrCLSIDs);
			}
		}
		if (bNoInstance) FreeLibrary(hModule);

		int iResult;
		CString strResult;
		if (nClassIDs)
		{
			iResult = nClassIDs<nProgIDs ? wrnNotAllClsIDs : errSuccess;
			strResult="\t = (\"\");\r\n\t = .(\""+strFileName+"\", \"";
			for (int i=0;i<nProgIDs;i++)
			{
				if (i) strResult+="\r\n\t\t|";
				strResult+=arrProgIDs[i];
				strResult+="=";
				strResult+=arrCLSIDs[i];
			}
			strResult+="\");";
		}
		else
		{
			iResult=errNoClsIDs;
			strResult="    ";
		}
		CLoadResult::AssignResult(Value, iResult, strResult);
	}
};

BL_INIT_CONTEXT(CBLLoader);
